// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationcostprofiler

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.applicationcostprofiler.model.*
import aws.sdk.kotlin.services.applicationcostprofiler.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "ApplicationCostProfiler"
const val ServiceApiVersion: String = "2020-09-10"
const val SdkVersion: String = "0.12.0-beta"

internal class DefaultApplicationCostProfilerClient(override val config: ApplicationCostProfilerClient.Config) : ApplicationCostProfilerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Deletes the specified report definition in AWS Application Cost Profiler. This stops the report from being
     * generated.
     */
    override suspend fun deleteReportDefinition(input: DeleteReportDefinitionRequest): DeleteReportDefinitionResponse {
        val op = SdkHttpOperation.build<DeleteReportDefinitionRequest, DeleteReportDefinitionResponse> {
            serializer = DeleteReportDefinitionOperationSerializer()
            deserializer = DeleteReportDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteReportDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "application-cost-profiler"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the definition of a report already configured in AWS Application Cost Profiler.
     */
    override suspend fun getReportDefinition(input: GetReportDefinitionRequest): GetReportDefinitionResponse {
        val op = SdkHttpOperation.build<GetReportDefinitionRequest, GetReportDefinitionResponse> {
            serializer = GetReportDefinitionOperationSerializer()
            deserializer = GetReportDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetReportDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "application-cost-profiler"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Ingests application usage data from Amazon Simple Storage Service (Amazon S3).
     * The data must already exist in the S3 location. As part of the action, AWS Application Cost Profiler
     * copies the object from your S3 bucket to an S3 bucket owned by Amazon for processing
     * asynchronously.
     */
    override suspend fun importApplicationUsage(input: ImportApplicationUsageRequest): ImportApplicationUsageResponse {
        val op = SdkHttpOperation.build<ImportApplicationUsageRequest, ImportApplicationUsageResponse> {
            serializer = ImportApplicationUsageOperationSerializer()
            deserializer = ImportApplicationUsageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportApplicationUsage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "application-cost-profiler"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of all reports and their configurations for your AWS account.
     * The maximum number of reports is one.
     */
    override suspend fun listReportDefinitions(input: ListReportDefinitionsRequest): ListReportDefinitionsResponse {
        val op = SdkHttpOperation.build<ListReportDefinitionsRequest, ListReportDefinitionsResponse> {
            serializer = ListReportDefinitionsOperationSerializer()
            deserializer = ListReportDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListReportDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "application-cost-profiler"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates the report definition for a report in Application Cost Profiler.
     */
    override suspend fun putReportDefinition(input: PutReportDefinitionRequest): PutReportDefinitionResponse {
        val op = SdkHttpOperation.build<PutReportDefinitionRequest, PutReportDefinitionResponse> {
            serializer = PutReportDefinitionOperationSerializer()
            deserializer = PutReportDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutReportDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "application-cost-profiler"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates existing report in AWS Application Cost Profiler.
     */
    override suspend fun updateReportDefinition(input: UpdateReportDefinitionRequest): UpdateReportDefinitionResponse {
        val op = SdkHttpOperation.build<UpdateReportDefinitionRequest, UpdateReportDefinitionResponse> {
            serializer = UpdateReportDefinitionOperationSerializer()
            deserializer = UpdateReportDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateReportDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "application-cost-profiler"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
