// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationcostprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The configuration of a report in AWS Application Cost Profiler.
 */
class ReportDefinition private constructor(builder: Builder) {
    /**
     * Timestamp (milliseconds) when this report definition was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The location in Amazon Simple Storage Service (Amazon S3) the reports should be saved to.
     */
    val destinationS3Location: aws.sdk.kotlin.services.applicationcostprofiler.model.S3Location? = builder.destinationS3Location
    /**
     * The format used for the generated reports.
     */
    val format: aws.sdk.kotlin.services.applicationcostprofiler.model.Format? = builder.format
    /**
     * Timestamp (milliseconds) when this report definition was last updated.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * Description of the report
     */
    val reportDescription: kotlin.String? = builder.reportDescription
    /**
     * The cadence at which the report is generated.
     */
    val reportFrequency: aws.sdk.kotlin.services.applicationcostprofiler.model.ReportFrequency? = builder.reportFrequency
    /**
     * The ID of the report.
     */
    val reportId: kotlin.String? = builder.reportId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationcostprofiler.model.ReportDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReportDefinition(")
        append("createdAt=$createdAt,")
        append("destinationS3Location=$destinationS3Location,")
        append("format=$format,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("reportDescription=$reportDescription,")
        append("reportFrequency=$reportFrequency,")
        append("reportId=$reportId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (destinationS3Location?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (reportDescription?.hashCode() ?: 0)
        result = 31 * result + (reportFrequency?.hashCode() ?: 0)
        result = 31 * result + (reportId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReportDefinition

        if (createdAt != other.createdAt) return false
        if (destinationS3Location != other.destinationS3Location) return false
        if (format != other.format) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (reportDescription != other.reportDescription) return false
        if (reportFrequency != other.reportFrequency) return false
        if (reportId != other.reportId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationcostprofiler.model.ReportDefinition = Builder(this).apply(block).build()

    class Builder {
        /**
         * Timestamp (milliseconds) when this report definition was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location in Amazon Simple Storage Service (Amazon S3) the reports should be saved to.
         */
        var destinationS3Location: aws.sdk.kotlin.services.applicationcostprofiler.model.S3Location? = null
        /**
         * The format used for the generated reports.
         */
        var format: aws.sdk.kotlin.services.applicationcostprofiler.model.Format? = null
        /**
         * Timestamp (milliseconds) when this report definition was last updated.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Description of the report
         */
        var reportDescription: kotlin.String? = null
        /**
         * The cadence at which the report is generated.
         */
        var reportFrequency: aws.sdk.kotlin.services.applicationcostprofiler.model.ReportFrequency? = null
        /**
         * The ID of the report.
         */
        var reportId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationcostprofiler.model.ReportDefinition) : this() {
            this.createdAt = x.createdAt
            this.destinationS3Location = x.destinationS3Location
            this.format = x.format
            this.lastUpdatedAt = x.lastUpdatedAt
            this.reportDescription = x.reportDescription
            this.reportFrequency = x.reportFrequency
            this.reportId = x.reportId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationcostprofiler.model.ReportDefinition = ReportDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.applicationcostprofiler.model.S3Location] inside the given [block]
         */
        fun destinationS3Location(block: aws.sdk.kotlin.services.applicationcostprofiler.model.S3Location.Builder.() -> kotlin.Unit) {
            this.destinationS3Location = aws.sdk.kotlin.services.applicationcostprofiler.model.S3Location.invoke(block)
        }
    }
}
