// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationcostprofiler.model



/**
 * Represents the Amazon Simple Storage Service (Amazon S3) location where usage data is read
 * from.
 */
class SourceS3Location private constructor(builder: Builder) {
    /**
     * Name of the bucket.
     */
    val bucket: kotlin.String? = builder.bucket
    /**
     * Key of the object.
     */
    val key: kotlin.String? = builder.key
    /**
     * Region of the bucket. Only required for Regions that are disabled by default.
     * For more infomration about Regions that are disabled by default, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">
     * Enabling a Region in the AWS General Reference guide.
     */
    val region: aws.sdk.kotlin.services.applicationcostprofiler.model.S3BucketRegion? = builder.region

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationcostprofiler.model.SourceS3Location = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceS3Location(")
        append("bucket=$bucket,")
        append("key=$key,")
        append("region=$region)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceS3Location

        if (bucket != other.bucket) return false
        if (key != other.key) return false
        if (region != other.region) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationcostprofiler.model.SourceS3Location = Builder(this).apply(block).build()

    class Builder {
        /**
         * Name of the bucket.
         */
        var bucket: kotlin.String? = null
        /**
         * Key of the object.
         */
        var key: kotlin.String? = null
        /**
         * Region of the bucket. Only required for Regions that are disabled by default.
         * For more infomration about Regions that are disabled by default, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">
         * Enabling a Region in the AWS General Reference guide.
         */
        var region: aws.sdk.kotlin.services.applicationcostprofiler.model.S3BucketRegion? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationcostprofiler.model.SourceS3Location) : this() {
            this.bucket = x.bucket
            this.key = x.key
            this.region = x.region
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationcostprofiler.model.SourceS3Location = SourceS3Location(this)
    }
}
