// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a retry policy. Specify at least one value for at least one of the types of `RetryEvents`, a value for `maxRetries`, and a value for `perRetryTimeout`. Both `server-error` and `gateway-error` under `httpRetryEvents` include the Envoy `reset` policy. For more information on the `reset` policy, see the [Envoy documentation](https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on).
 */
public class HttpRetryPolicy private constructor(builder: Builder) {
    /**
     * Specify at least one of the following values.
     * + **server-error** – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
     * + **gateway-error** – HTTP status codes 502, 503, and 504
     * + **client-error** – HTTP status code 409
     * + **stream-error** – Retry on refused stream
     */
    public val httpRetryEvents: List<String>? = builder.httpRetryEvents
    /**
     * The maximum number of retry attempts.
     */
    public val maxRetries: kotlin.Long? = builder.maxRetries
    /**
     * The timeout for each retry attempt.
     */
    public val perRetryTimeout: aws.sdk.kotlin.services.appmesh.model.Duration? = builder.perRetryTimeout
    /**
     * Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.
     */
    public val tcpRetryEvents: List<TcpRetryPolicyEvent>? = builder.tcpRetryEvents

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.HttpRetryPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpRetryPolicy(")
        append("httpRetryEvents=$httpRetryEvents,")
        append("maxRetries=$maxRetries,")
        append("perRetryTimeout=$perRetryTimeout,")
        append("tcpRetryEvents=$tcpRetryEvents)")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpRetryEvents?.hashCode() ?: 0
        result = 31 * result + (maxRetries?.hashCode() ?: 0)
        result = 31 * result + (perRetryTimeout?.hashCode() ?: 0)
        result = 31 * result + (tcpRetryEvents?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpRetryPolicy

        if (httpRetryEvents != other.httpRetryEvents) return false
        if (maxRetries != other.maxRetries) return false
        if (perRetryTimeout != other.perRetryTimeout) return false
        if (tcpRetryEvents != other.tcpRetryEvents) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.HttpRetryPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify at least one of the following values.
         * + **server-error** – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511
         * + **gateway-error** – HTTP status codes 502, 503, and 504
         * + **client-error** – HTTP status code 409
         * + **stream-error** – Retry on refused stream
         */
        public var httpRetryEvents: List<String>? = null
        /**
         * The maximum number of retry attempts.
         */
        public var maxRetries: kotlin.Long? = null
        /**
         * The timeout for each retry attempt.
         */
        public var perRetryTimeout: aws.sdk.kotlin.services.appmesh.model.Duration? = null
        /**
         * Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.
         */
        public var tcpRetryEvents: List<TcpRetryPolicyEvent>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.HttpRetryPolicy) : this() {
            this.httpRetryEvents = x.httpRetryEvents
            this.maxRetries = x.maxRetries
            this.perRetryTimeout = x.perRetryTimeout
            this.tcpRetryEvents = x.tcpRetryEvents
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.HttpRetryPolicy = HttpRetryPolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.Duration] inside the given [block]
         */
        public fun perRetryTimeout(block: aws.sdk.kotlin.services.appmesh.model.Duration.Builder.() -> kotlin.Unit) {
            this.perRetryTimeout = aws.sdk.kotlin.services.appmesh.model.Duration.invoke(block)
        }
    }
}
