// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



public class UpdateGatewayRouteRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the gateway route to update.
     */
    public val gatewayRouteName: kotlin.String? = requireNotNull(builder.gatewayRouteName) { "A non-null value must be provided for gatewayRouteName" }
    /**
     * The name of the service mesh that the gateway route resides in.
     */
    public val meshName: kotlin.String? = requireNotNull(builder.meshName) { "A non-null value must be provided for meshName" }
    /**
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    public val meshOwner: kotlin.String? = builder.meshOwner
    /**
     * The new gateway route specification to apply. This overwrites the existing data.
     */
    public val spec: aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec? = builder.spec
    /**
     * The name of the virtual gateway that the gateway route is associated with.
     */
    public val virtualGatewayName: kotlin.String? = requireNotNull(builder.virtualGatewayName) { "A non-null value must be provided for virtualGatewayName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.UpdateGatewayRouteRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateGatewayRouteRequest(")
        append("clientToken=$clientToken,")
        append("gatewayRouteName=$gatewayRouteName,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("spec=$spec,")
        append("virtualGatewayName=$virtualGatewayName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (gatewayRouteName?.hashCode() ?: 0)
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateGatewayRouteRequest

        if (clientToken != other.clientToken) return false
        if (gatewayRouteName != other.gatewayRouteName) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (spec != other.spec) return false
        if (virtualGatewayName != other.virtualGatewayName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.UpdateGatewayRouteRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the gateway route to update.
         */
        public var gatewayRouteName: kotlin.String? = null
        /**
         * The name of the service mesh that the gateway route resides in.
         */
        public var meshName: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        public var meshOwner: kotlin.String? = null
        /**
         * The new gateway route specification to apply. This overwrites the existing data.
         */
        public var spec: aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec? = null
        /**
         * The name of the virtual gateway that the gateway route is associated with.
         */
        public var virtualGatewayName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.UpdateGatewayRouteRequest) : this() {
            this.clientToken = x.clientToken
            this.gatewayRouteName = x.gatewayRouteName
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.spec = x.spec
            this.virtualGatewayName = x.virtualGatewayName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.UpdateGatewayRouteRequest = UpdateGatewayRouteRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec] inside the given [block]
         */
        public fun spec(block: aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec.Builder.() -> kotlin.Unit) {
            this.spec = aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec.invoke(block)
        }
    }
}
