// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the health check policy for a virtual gateway's listener.
 */
public class VirtualGatewayHealthCheckPolicy private constructor(builder: Builder) {
    /**
     * The number of consecutive successful health checks that must occur before declaring the listener healthy.
     */
    public val healthyThreshold: kotlin.Int = builder.healthyThreshold
    /**
     * The time period in milliseconds between each health check execution.
     */
    public val intervalMillis: kotlin.Long? = builder.intervalMillis
    /**
     * The destination path for the health check request. This value is only used if the specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The destination port for the health check request. This port must match the port defined in the PortMapping for the listener.
     */
    public val port: kotlin.Int = builder.port
    /**
     * The protocol for the health check request. If you specify `grpc`, then your service must conform to the [GRPC Health Checking Protocol](https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
     */
    public val protocol: aws.sdk.kotlin.services.appmesh.model.VirtualGatewayPortProtocol? = builder.protocol
    /**
     * The amount of time to wait when receiving a response from the health check, in milliseconds.
     */
    public val timeoutMillis: kotlin.Long? = builder.timeoutMillis
    /**
     * The number of consecutive failed health checks that must occur before declaring a virtual gateway unhealthy.
     */
    public val unhealthyThreshold: kotlin.Int = builder.unhealthyThreshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.VirtualGatewayHealthCheckPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualGatewayHealthCheckPolicy(")
        append("healthyThreshold=$healthyThreshold,")
        append("intervalMillis=$intervalMillis,")
        append("path=$path,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("timeoutMillis=$timeoutMillis,")
        append("unhealthyThreshold=$unhealthyThreshold)")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthyThreshold
        result = 31 * result + (intervalMillis?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (port)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (timeoutMillis?.hashCode() ?: 0)
        result = 31 * result + (unhealthyThreshold)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VirtualGatewayHealthCheckPolicy

        if (healthyThreshold != other.healthyThreshold) return false
        if (intervalMillis != other.intervalMillis) return false
        if (path != other.path) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (timeoutMillis != other.timeoutMillis) return false
        if (unhealthyThreshold != other.unhealthyThreshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.VirtualGatewayHealthCheckPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of consecutive successful health checks that must occur before declaring the listener healthy.
         */
        public var healthyThreshold: kotlin.Int = 0
        /**
         * The time period in milliseconds between each health check execution.
         */
        public var intervalMillis: kotlin.Long? = null
        /**
         * The destination path for the health check request. This value is only used if the specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.
         */
        public var path: kotlin.String? = null
        /**
         * The destination port for the health check request. This port must match the port defined in the PortMapping for the listener.
         */
        public var port: kotlin.Int = 0
        /**
         * The protocol for the health check request. If you specify `grpc`, then your service must conform to the [GRPC Health Checking Protocol](https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
         */
        public var protocol: aws.sdk.kotlin.services.appmesh.model.VirtualGatewayPortProtocol? = null
        /**
         * The amount of time to wait when receiving a response from the health check, in milliseconds.
         */
        public var timeoutMillis: kotlin.Long? = null
        /**
         * The number of consecutive failed health checks that must occur before declaring a virtual gateway unhealthy.
         */
        public var unhealthyThreshold: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.VirtualGatewayHealthCheckPolicy) : this() {
            this.healthyThreshold = x.healthyThreshold
            this.intervalMillis = x.intervalMillis
            this.path = x.path
            this.port = x.port
            this.protocol = x.protocol
            this.timeoutMillis = x.timeoutMillis
            this.unhealthyThreshold = x.unhealthyThreshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.VirtualGatewayHealthCheckPolicy = VirtualGatewayHealthCheckPolicy(this)
    }
}
