// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * Deletes a virtual node input.
 */
class DeleteVirtualNodeRequest private constructor(builder: Builder) {
    /**
     * The name of the service mesh to delete the virtual node in.
     */
    val meshName: kotlin.String? = builder.meshName
    /**
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
     */
    val meshOwner: kotlin.String? = builder.meshOwner
    /**
     * The name of the virtual node to delete.
     */
    val virtualNodeName: kotlin.String? = builder.virtualNodeName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.DeleteVirtualNodeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteVirtualNodeRequest(")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("virtualNodeName=$virtualNodeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = meshName?.hashCode() ?: 0
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (virtualNodeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteVirtualNodeRequest

        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (virtualNodeName != other.virtualNodeName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.DeleteVirtualNodeRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the service mesh to delete the virtual node in.
         */
        var meshName: kotlin.String? = null
        /**
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see [Working with shared meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
         */
        var meshOwner: kotlin.String? = null
        /**
         * The name of the virtual node to delete.
         */
        var virtualNodeName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.DeleteVirtualNodeRequest) : this() {
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.virtualNodeName = x.virtualNodeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.DeleteVirtualNodeRequest = DeleteVirtualNodeRequest(this)
    }
}
