// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the outlier detection for a virtual node's listener.
 */
class OutlierDetection private constructor(builder: Builder) {
    /**
     * The base amount of time for which a host is ejected.
     */
    val baseEjectionDuration: aws.sdk.kotlin.services.appmesh.model.Duration? = builder.baseEjectionDuration
    /**
     * The time interval between ejection sweep analysis.
     */
    val interval: aws.sdk.kotlin.services.appmesh.model.Duration? = builder.interval
    /**
     * Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. Will eject at least one host regardless of the value.
     */
    val maxEjectionPercent: kotlin.Int? = builder.maxEjectionPercent
    /**
     * Number of consecutive `5xx` errors required for ejection.
     */
    val maxServerErrors: kotlin.Long? = builder.maxServerErrors

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appmesh.model.OutlierDetection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutlierDetection(")
        append("baseEjectionDuration=$baseEjectionDuration,")
        append("interval=$interval,")
        append("maxEjectionPercent=$maxEjectionPercent,")
        append("maxServerErrors=$maxServerErrors)")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseEjectionDuration?.hashCode() ?: 0
        result = 31 * result + (interval?.hashCode() ?: 0)
        result = 31 * result + (maxEjectionPercent ?: 0)
        result = 31 * result + (maxServerErrors?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutlierDetection

        if (baseEjectionDuration != other.baseEjectionDuration) return false
        if (interval != other.interval) return false
        if (maxEjectionPercent != other.maxEjectionPercent) return false
        if (maxServerErrors != other.maxServerErrors) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appmesh.model.OutlierDetection = Builder(this).apply(block).build()

    class Builder {
        /**
         * The base amount of time for which a host is ejected.
         */
        var baseEjectionDuration: aws.sdk.kotlin.services.appmesh.model.Duration? = null
        /**
         * The time interval between ejection sweep analysis.
         */
        var interval: aws.sdk.kotlin.services.appmesh.model.Duration? = null
        /**
         * Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. Will eject at least one host regardless of the value.
         */
        var maxEjectionPercent: kotlin.Int? = null
        /**
         * Number of consecutive `5xx` errors required for ejection.
         */
        var maxServerErrors: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appmesh.model.OutlierDetection) : this() {
            this.baseEjectionDuration = x.baseEjectionDuration
            this.interval = x.interval
            this.maxEjectionPercent = x.maxEjectionPercent
            this.maxServerErrors = x.maxServerErrors
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appmesh.model.OutlierDetection = OutlierDetection(this)

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.Duration] inside the given [block]
         */
        fun baseEjectionDuration(block: aws.sdk.kotlin.services.appmesh.model.Duration.Builder.() -> kotlin.Unit) {
            this.baseEjectionDuration = aws.sdk.kotlin.services.appmesh.model.Duration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.Duration] inside the given [block]
         */
        fun interval(block: aws.sdk.kotlin.services.appmesh.model.Duration.Builder.() -> kotlin.Unit) {
            this.interval = aws.sdk.kotlin.services.appmesh.model.Duration.invoke(block)
        }
    }
}
