// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * A reference to an object that represents a Transport Layer Security (TLS) client policy.
 */
class ClientPolicyTls private constructor(builder: BuilderImpl) {
    /**
     * A reference to an object that represents a client's TLS certificate.
     */
    val certificate: ClientTlsCertificate? = builder.certificate
    /**
     * Whether the policy is enforced. The default is True, if a value isn't specified.
     */
    val enforce: Boolean? = builder.enforce
    /**
     * One or more ports that the policy is enforced for.
     */
    val ports: Set<Int>? = builder.ports
    /**
     * A reference to an object that represents a TLS validation context.
     */
    val validation: TlsValidationContext? = builder.validation

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClientPolicyTls = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClientPolicyTls(")
        append("certificate=$certificate,")
        append("enforce=$enforce,")
        append("ports=$ports,")
        append("validation=$validation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.hashCode() ?: 0
        result = 31 * result + (enforce?.hashCode() ?: 0)
        result = 31 * result + (ports?.hashCode() ?: 0)
        result = 31 * result + (validation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClientPolicyTls

        if (certificate != other.certificate) return false
        if (enforce != other.enforce) return false
        if (ports != other.ports) return false
        if (validation != other.validation) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClientPolicyTls = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClientPolicyTls
        /**
         * A reference to an object that represents a client's TLS certificate.
         */
        fun certificate(certificate: ClientTlsCertificate): FluentBuilder
        /**
         * Whether the policy is enforced. The default is True, if a value isn't specified.
         */
        fun enforce(enforce: Boolean): FluentBuilder
        /**
         * One or more ports that the policy is enforced for.
         */
        fun ports(ports: Set<Int>): FluentBuilder
        /**
         * A reference to an object that represents a TLS validation context.
         */
        fun validation(validation: TlsValidationContext): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A reference to an object that represents a client's TLS certificate.
         */
        var certificate: ClientTlsCertificate?
        /**
         * Whether the policy is enforced. The default is True, if a value isn't specified.
         */
        var enforce: Boolean?
        /**
         * One or more ports that the policy is enforced for.
         */
        var ports: Set<Int>?
        /**
         * A reference to an object that represents a TLS validation context.
         */
        var validation: TlsValidationContext?

        fun build(): ClientPolicyTls
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.TlsValidationContext] inside the given [block]
         */
        fun validation(block: TlsValidationContext.DslBuilder.() -> kotlin.Unit) {
            this.validation = TlsValidationContext.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificate: ClientTlsCertificate? = null
        override var enforce: Boolean? = null
        override var ports: Set<Int>? = null
        override var validation: TlsValidationContext? = null

        constructor(x: ClientPolicyTls) : this() {
            this.certificate = x.certificate
            this.enforce = x.enforce
            this.ports = x.ports
            this.validation = x.validation
        }

        override fun build(): ClientPolicyTls = ClientPolicyTls(this)
        override fun certificate(certificate: ClientTlsCertificate): FluentBuilder = apply { this.certificate = certificate }
        override fun enforce(enforce: Boolean): FluentBuilder = apply { this.enforce = enforce }
        override fun ports(ports: Set<Int>): FluentBuilder = apply { this.ports = ports }
        override fun validation(validation: TlsValidationContext): FluentBuilder = apply { this.validation = validation }
    }
}
