// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



class CreateVirtualGatewayRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The name of the service mesh to create the virtual gateway in.
     */
    val meshName: String? = builder.meshName
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
     * the account that you specify must share the mesh with your account before you can create
     * the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: String? = builder.meshOwner
    /**
     * The virtual gateway specification to apply.
     */
    val spec: VirtualGatewaySpec? = builder.spec
    /**
     * Optional metadata that you can apply to the virtual gateway to assist with
     * categorization and organization. Each tag consists of a key and an optional value, both of
     * which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have
     * a maximum length of 256 characters.
     */
    val tags: List<TagRef>? = builder.tags
    /**
     * The name to use for the virtual gateway.
     */
    val virtualGatewayName: String? = builder.virtualGatewayName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateVirtualGatewayRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVirtualGatewayRequest(")
        append("clientToken=$clientToken,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("spec=$spec,")
        append("tags=$tags,")
        append("virtualGatewayName=$virtualGatewayName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateVirtualGatewayRequest

        if (clientToken != other.clientToken) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (spec != other.spec) return false
        if (tags != other.tags) return false
        if (virtualGatewayName != other.virtualGatewayName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateVirtualGatewayRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateVirtualGatewayRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The name of the service mesh to create the virtual gateway in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
         * the account that you specify must share the mesh with your account before you can create
         * the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun meshOwner(meshOwner: String): FluentBuilder
        /**
         * The virtual gateway specification to apply.
         */
        fun spec(spec: VirtualGatewaySpec): FluentBuilder
        /**
         * Optional metadata that you can apply to the virtual gateway to assist with
         * categorization and organization. Each tag consists of a key and an optional value, both of
         * which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have
         * a maximum length of 256 characters.
         */
        fun tags(tags: List<TagRef>): FluentBuilder
        /**
         * The name to use for the virtual gateway.
         */
        fun virtualGatewayName(virtualGatewayName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        var clientToken: String?
        /**
         * The name of the service mesh to create the virtual gateway in.
         */
        var meshName: String?
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then
         * the account that you specify must share the mesh with your account before you can create
         * the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: String?
        /**
         * The virtual gateway specification to apply.
         */
        var spec: VirtualGatewaySpec?
        /**
         * Optional metadata that you can apply to the virtual gateway to assist with
         * categorization and organization. Each tag consists of a key and an optional value, both of
         * which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have
         * a maximum length of 256 characters.
         */
        var tags: List<TagRef>?
        /**
         * The name to use for the virtual gateway.
         */
        var virtualGatewayName: String?

        fun build(): CreateVirtualGatewayRequest
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualGatewaySpec] inside the given [block]
         */
        fun spec(block: VirtualGatewaySpec.DslBuilder.() -> kotlin.Unit) {
            this.spec = VirtualGatewaySpec.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var meshName: String? = null
        override var meshOwner: String? = null
        override var spec: VirtualGatewaySpec? = null
        override var tags: List<TagRef>? = null
        override var virtualGatewayName: String? = null

        constructor(x: CreateVirtualGatewayRequest) : this() {
            this.clientToken = x.clientToken
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.spec = x.spec
            this.tags = x.tags
            this.virtualGatewayName = x.virtualGatewayName
        }

        override fun build(): CreateVirtualGatewayRequest = CreateVirtualGatewayRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun meshOwner(meshOwner: String): FluentBuilder = apply { this.meshOwner = meshOwner }
        override fun spec(spec: VirtualGatewaySpec): FluentBuilder = apply { this.spec = spec }
        override fun tags(tags: List<TagRef>): FluentBuilder = apply { this.tags = tags }
        override fun virtualGatewayName(virtualGatewayName: String): FluentBuilder = apply { this.virtualGatewayName = virtualGatewayName }
    }
}
