// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



class DeleteGatewayRouteRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the gateway route to delete.
     */
    val gatewayRouteName: String? = builder.gatewayRouteName
    /**
     * The name of the service mesh to delete the gateway route from.
     */
    val meshName: String? = builder.meshName
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: String? = builder.meshOwner
    /**
     * The name of the virtual gateway to delete the route from.
     */
    val virtualGatewayName: String? = builder.virtualGatewayName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteGatewayRouteRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteGatewayRouteRequest(")
        append("gatewayRouteName=$gatewayRouteName,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("virtualGatewayName=$virtualGatewayName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayRouteName?.hashCode() ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteGatewayRouteRequest

        if (gatewayRouteName != other.gatewayRouteName) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (virtualGatewayName != other.virtualGatewayName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteGatewayRouteRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteGatewayRouteRequest
        /**
         * The name of the gateway route to delete.
         */
        fun gatewayRouteName(gatewayRouteName: String): FluentBuilder
        /**
         * The name of the service mesh to delete the gateway route from.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun meshOwner(meshOwner: String): FluentBuilder
        /**
         * The name of the virtual gateway to delete the route from.
         */
        fun virtualGatewayName(virtualGatewayName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the gateway route to delete.
         */
        var gatewayRouteName: String?
        /**
         * The name of the service mesh to delete the gateway route from.
         */
        var meshName: String?
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: String?
        /**
         * The name of the virtual gateway to delete the route from.
         */
        var virtualGatewayName: String?

        fun build(): DeleteGatewayRouteRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var gatewayRouteName: String? = null
        override var meshName: String? = null
        override var meshOwner: String? = null
        override var virtualGatewayName: String? = null

        constructor(x: DeleteGatewayRouteRequest) : this() {
            this.gatewayRouteName = x.gatewayRouteName
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.virtualGatewayName = x.virtualGatewayName
        }

        override fun build(): DeleteGatewayRouteRequest = DeleteGatewayRouteRequest(this)
        override fun gatewayRouteName(gatewayRouteName: String): FluentBuilder = apply { this.gatewayRouteName = gatewayRouteName }
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun meshOwner(meshOwner: String): FluentBuilder = apply { this.meshOwner = meshOwner }
        override fun virtualGatewayName(virtualGatewayName: String): FluentBuilder = apply { this.virtualGatewayName = virtualGatewayName }
    }
}
