// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * Deletes a virtual node input.
 */
class DeleteVirtualNodeRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the service mesh to delete the virtual node in.
     */
    val meshName: String? = builder.meshName
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: String? = builder.meshOwner
    /**
     * The name of the virtual node to delete.
     */
    val virtualNodeName: String? = builder.virtualNodeName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteVirtualNodeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteVirtualNodeRequest(")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("virtualNodeName=$virtualNodeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = meshName?.hashCode() ?: 0
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (virtualNodeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteVirtualNodeRequest

        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (virtualNodeName != other.virtualNodeName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteVirtualNodeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteVirtualNodeRequest
        /**
         * The name of the service mesh to delete the virtual node in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun meshOwner(meshOwner: String): FluentBuilder
        /**
         * The name of the virtual node to delete.
         */
        fun virtualNodeName(virtualNodeName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the service mesh to delete the virtual node in.
         */
        var meshName: String?
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: String?
        /**
         * The name of the virtual node to delete.
         */
        var virtualNodeName: String?

        fun build(): DeleteVirtualNodeRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var meshName: String? = null
        override var meshOwner: String? = null
        override var virtualNodeName: String? = null

        constructor(x: DeleteVirtualNodeRequest) : this() {
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.virtualNodeName = x.virtualNodeName
        }

        override fun build(): DeleteVirtualNodeRequest = DeleteVirtualNodeRequest(this)
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun meshOwner(meshOwner: String): FluentBuilder = apply { this.meshOwner = meshOwner }
        override fun virtualNodeName(virtualNodeName: String): FluentBuilder = apply { this.virtualNodeName = virtualNodeName }
    }
}
