// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 *
 */
class DeleteVirtualServiceRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the service mesh to delete the virtual service in.
     */
    val meshName: String? = builder.meshName
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: String? = builder.meshOwner
    /**
     * The name of the virtual service to delete.
     */
    val virtualServiceName: String? = builder.virtualServiceName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteVirtualServiceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteVirtualServiceRequest(")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("virtualServiceName=$virtualServiceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = meshName?.hashCode() ?: 0
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (virtualServiceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteVirtualServiceRequest

        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (virtualServiceName != other.virtualServiceName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteVirtualServiceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteVirtualServiceRequest
        /**
         * The name of the service mesh to delete the virtual service in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun meshOwner(meshOwner: String): FluentBuilder
        /**
         * The name of the virtual service to delete.
         */
        fun virtualServiceName(virtualServiceName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the service mesh to delete the virtual service in.
         */
        var meshName: String?
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: String?
        /**
         * The name of the virtual service to delete.
         */
        var virtualServiceName: String?

        fun build(): DeleteVirtualServiceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var meshName: String? = null
        override var meshOwner: String? = null
        override var virtualServiceName: String? = null

        constructor(x: DeleteVirtualServiceRequest) : this() {
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.virtualServiceName = x.virtualServiceName
        }

        override fun build(): DeleteVirtualServiceRequest = DeleteVirtualServiceRequest(this)
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun meshOwner(meshOwner: String): FluentBuilder = apply { this.meshOwner = meshOwner }
        override fun virtualServiceName(virtualServiceName: String): FluentBuilder = apply { this.virtualServiceName = virtualServiceName }
    }
}
