// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a gateway route returned by a describe operation.
 */
class GatewayRouteData private constructor(builder: BuilderImpl) {
    /**
     * The name of the gateway route.
     */
    val gatewayRouteName: String? = builder.gatewayRouteName
    /**
     * The name of the service mesh that the resource resides in.
     */
    val meshName: String? = builder.meshName
    /**
     * An object that represents metadata for a resource.
     */
    val metadata: ResourceMetadata? = builder.metadata
    /**
     * The specifications of the gateway route.
     */
    val spec: GatewayRouteSpec? = builder.spec
    /**
     * The status of the gateway route.
     */
    val status: GatewayRouteStatus? = builder.status
    /**
     * The virtual gateway that the gateway route is associated with.
     */
    val virtualGatewayName: String? = builder.virtualGatewayName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GatewayRouteData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GatewayRouteData(")
        append("gatewayRouteName=$gatewayRouteName,")
        append("meshName=$meshName,")
        append("metadata=$metadata,")
        append("spec=$spec,")
        append("status=$status,")
        append("virtualGatewayName=$virtualGatewayName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayRouteName?.hashCode() ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GatewayRouteData

        if (gatewayRouteName != other.gatewayRouteName) return false
        if (meshName != other.meshName) return false
        if (metadata != other.metadata) return false
        if (spec != other.spec) return false
        if (status != other.status) return false
        if (virtualGatewayName != other.virtualGatewayName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GatewayRouteData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GatewayRouteData
        /**
         * The name of the gateway route.
         */
        fun gatewayRouteName(gatewayRouteName: String): FluentBuilder
        /**
         * The name of the service mesh that the resource resides in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * An object that represents metadata for a resource.
         */
        fun metadata(metadata: ResourceMetadata): FluentBuilder
        /**
         * The specifications of the gateway route.
         */
        fun spec(spec: GatewayRouteSpec): FluentBuilder
        /**
         * The status of the gateway route.
         */
        fun status(status: GatewayRouteStatus): FluentBuilder
        /**
         * The virtual gateway that the gateway route is associated with.
         */
        fun virtualGatewayName(virtualGatewayName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the gateway route.
         */
        var gatewayRouteName: String?
        /**
         * The name of the service mesh that the resource resides in.
         */
        var meshName: String?
        /**
         * An object that represents metadata for a resource.
         */
        var metadata: ResourceMetadata?
        /**
         * The specifications of the gateway route.
         */
        var spec: GatewayRouteSpec?
        /**
         * The status of the gateway route.
         */
        var status: GatewayRouteStatus?
        /**
         * The virtual gateway that the gateway route is associated with.
         */
        var virtualGatewayName: String?

        fun build(): GatewayRouteData
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.ResourceMetadata] inside the given [block]
         */
        fun metadata(block: ResourceMetadata.DslBuilder.() -> kotlin.Unit) {
            this.metadata = ResourceMetadata.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec] inside the given [block]
         */
        fun spec(block: GatewayRouteSpec.DslBuilder.() -> kotlin.Unit) {
            this.spec = GatewayRouteSpec.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.GatewayRouteStatus] inside the given [block]
         */
        fun status(block: GatewayRouteStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = GatewayRouteStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var gatewayRouteName: String? = null
        override var meshName: String? = null
        override var metadata: ResourceMetadata? = null
        override var spec: GatewayRouteSpec? = null
        override var status: GatewayRouteStatus? = null
        override var virtualGatewayName: String? = null

        constructor(x: GatewayRouteData) : this() {
            this.gatewayRouteName = x.gatewayRouteName
            this.meshName = x.meshName
            this.metadata = x.metadata
            this.spec = x.spec
            this.status = x.status
            this.virtualGatewayName = x.virtualGatewayName
        }

        override fun build(): GatewayRouteData = GatewayRouteData(this)
        override fun gatewayRouteName(gatewayRouteName: String): FluentBuilder = apply { this.gatewayRouteName = gatewayRouteName }
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun metadata(metadata: ResourceMetadata): FluentBuilder = apply { this.metadata = metadata }
        override fun spec(spec: GatewayRouteSpec): FluentBuilder = apply { this.spec = spec }
        override fun status(status: GatewayRouteStatus): FluentBuilder = apply { this.status = status }
        override fun virtualGatewayName(virtualGatewayName: String): FluentBuilder = apply { this.virtualGatewayName = virtualGatewayName }
    }
}
