// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that represents a gateway route returned by a list operation.
 */
class GatewayRouteRef private constructor(builder: BuilderImpl) {
    /**
     * The full Amazon Resource Name (ARN) for the gateway route.
     */
    val arn: String? = builder.arn
    /**
     * The Unix epoch timestamp in seconds for when the resource was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The name of the gateway route.
     */
    val gatewayRouteName: String? = builder.gatewayRouteName
    /**
     * The Unix epoch timestamp in seconds for when the resource was last updated.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The name of the service mesh that the resource resides in.
     */
    val meshName: String? = builder.meshName
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: String? = builder.meshOwner
    /**
     * The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
     * the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val resourceOwner: String? = builder.resourceOwner
    /**
     * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
     */
    val version: Long? = builder.version
    /**
     * The virtual gateway that the gateway route is associated with.
     */
    val virtualGatewayName: String? = builder.virtualGatewayName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GatewayRouteRef = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GatewayRouteRef(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("gatewayRouteName=$gatewayRouteName,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("resourceOwner=$resourceOwner,")
        append("version=$version,")
        append("virtualGatewayName=$virtualGatewayName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (gatewayRouteName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (resourceOwner?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GatewayRouteRef

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (gatewayRouteName != other.gatewayRouteName) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (resourceOwner != other.resourceOwner) return false
        if (version != other.version) return false
        if (virtualGatewayName != other.virtualGatewayName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GatewayRouteRef = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GatewayRouteRef
        /**
         * The full Amazon Resource Name (ARN) for the gateway route.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The Unix epoch timestamp in seconds for when the resource was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The name of the gateway route.
         */
        fun gatewayRouteName(gatewayRouteName: String): FluentBuilder
        /**
         * The Unix epoch timestamp in seconds for when the resource was last updated.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The name of the service mesh that the resource resides in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun meshOwner(meshOwner: String): FluentBuilder
        /**
         * The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
         * the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun resourceOwner(resourceOwner: String): FluentBuilder
        /**
         * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
         */
        fun version(version: Long): FluentBuilder
        /**
         * The virtual gateway that the gateway route is associated with.
         */
        fun virtualGatewayName(virtualGatewayName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The full Amazon Resource Name (ARN) for the gateway route.
         */
        var arn: String?
        /**
         * The Unix epoch timestamp in seconds for when the resource was created.
         */
        var createdAt: Instant?
        /**
         * The name of the gateway route.
         */
        var gatewayRouteName: String?
        /**
         * The Unix epoch timestamp in seconds for when the resource was last updated.
         */
        var lastUpdatedAt: Instant?
        /**
         * The name of the service mesh that the resource resides in.
         */
        var meshName: String?
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: String?
        /**
         * The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
         * the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var resourceOwner: String?
        /**
         * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
         */
        var version: Long?
        /**
         * The virtual gateway that the gateway route is associated with.
         */
        var virtualGatewayName: String?

        fun build(): GatewayRouteRef
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var createdAt: Instant? = null
        override var gatewayRouteName: String? = null
        override var lastUpdatedAt: Instant? = null
        override var meshName: String? = null
        override var meshOwner: String? = null
        override var resourceOwner: String? = null
        override var version: Long? = null
        override var virtualGatewayName: String? = null

        constructor(x: GatewayRouteRef) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.gatewayRouteName = x.gatewayRouteName
            this.lastUpdatedAt = x.lastUpdatedAt
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.resourceOwner = x.resourceOwner
            this.version = x.version
            this.virtualGatewayName = x.virtualGatewayName
        }

        override fun build(): GatewayRouteRef = GatewayRouteRef(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun gatewayRouteName(gatewayRouteName: String): FluentBuilder = apply { this.gatewayRouteName = gatewayRouteName }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun meshOwner(meshOwner: String): FluentBuilder = apply { this.meshOwner = meshOwner }
        override fun resourceOwner(resourceOwner: String): FluentBuilder = apply { this.resourceOwner = resourceOwner }
        override fun version(version: Long): FluentBuilder = apply { this.version = version }
        override fun virtualGatewayName(virtualGatewayName: String): FluentBuilder = apply { this.virtualGatewayName = virtualGatewayName }
    }
}
