// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents types of timeouts.
 */
class GrpcTimeout private constructor(builder: BuilderImpl) {
    /**
     * An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
     */
    val idle: Duration? = builder.idle
    /**
     * An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh
     * resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15
     * seconds for the source and destination virtual node and the route.
     */
    val perRequest: Duration? = builder.perRequest

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GrpcTimeout = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GrpcTimeout(")
        append("idle=$idle,")
        append("perRequest=$perRequest)")
    }

    override fun hashCode(): kotlin.Int {
        var result = idle?.hashCode() ?: 0
        result = 31 * result + (perRequest?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GrpcTimeout

        if (idle != other.idle) return false
        if (perRequest != other.perRequest) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GrpcTimeout = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GrpcTimeout
        /**
         * An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
         */
        fun idle(idle: Duration): FluentBuilder
        /**
         * An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh
         * resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15
         * seconds for the source and destination virtual node and the route.
         */
        fun perRequest(perRequest: Duration): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
         */
        var idle: Duration?
        /**
         * An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh
         * resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15
         * seconds for the source and destination virtual node and the route.
         */
        var perRequest: Duration?

        fun build(): GrpcTimeout
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.Duration] inside the given [block]
         */
        fun idle(block: Duration.DslBuilder.() -> kotlin.Unit) {
            this.idle = Duration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.Duration] inside the given [block]
         */
        fun perRequest(block: Duration.DslBuilder.() -> kotlin.Unit) {
            this.perRequest = Duration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var idle: Duration? = null
        override var perRequest: Duration? = null

        constructor(x: GrpcTimeout) : this() {
            this.idle = x.idle
            this.perRequest = x.perRequest
        }

        override fun build(): GrpcTimeout = GrpcTimeout(this)
        override fun idle(idle: Duration): FluentBuilder = apply { this.idle = idle }
        override fun perRequest(perRequest: Duration): FluentBuilder = apply { this.perRequest = perRequest }
    }
}
