// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the health check policy for a virtual node's listener.
 */
class HealthCheckPolicy private constructor(builder: BuilderImpl) {
    /**
     * The number of consecutive successful health checks that must occur before declaring
     * listener healthy.
     */
    val healthyThreshold: Int = builder.healthyThreshold
    /**
     * The time period in milliseconds between each health check execution.
     */
    val intervalMillis: Long? = builder.intervalMillis
    /**
     * The destination path for the health check request. This value is only used if the
     * specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.
     */
    val path: String? = builder.path
    /**
     * The destination port for the health check request. This port must match the port defined
     * in the PortMapping for the listener.
     */
    val port: Int = builder.port
    /**
     * The protocol for the health check request. If you specify grpc, then your
     * service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
     * Checking Protocol.
     */
    val protocol: PortProtocol? = builder.protocol
    /**
     * The amount of time to wait when receiving a response from the health check, in
     * milliseconds.
     */
    val timeoutMillis: Long? = builder.timeoutMillis
    /**
     * The number of consecutive failed health checks that must occur before declaring a
     * virtual node unhealthy.
     */
    val unhealthyThreshold: Int = builder.unhealthyThreshold

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HealthCheckPolicy = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HealthCheckPolicy(")
        append("healthyThreshold=$healthyThreshold,")
        append("intervalMillis=$intervalMillis,")
        append("path=$path,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("timeoutMillis=$timeoutMillis,")
        append("unhealthyThreshold=$unhealthyThreshold)")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthyThreshold
        result = 31 * result + (intervalMillis?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (port)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (timeoutMillis?.hashCode() ?: 0)
        result = 31 * result + (unhealthyThreshold)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HealthCheckPolicy

        if (healthyThreshold != other.healthyThreshold) return false
        if (intervalMillis != other.intervalMillis) return false
        if (path != other.path) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (timeoutMillis != other.timeoutMillis) return false
        if (unhealthyThreshold != other.unhealthyThreshold) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HealthCheckPolicy = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HealthCheckPolicy
        /**
         * The number of consecutive successful health checks that must occur before declaring
         * listener healthy.
         */
        fun healthyThreshold(healthyThreshold: Int): FluentBuilder
        /**
         * The time period in milliseconds between each health check execution.
         */
        fun intervalMillis(intervalMillis: Long): FluentBuilder
        /**
         * The destination path for the health check request. This value is only used if the
         * specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.
         */
        fun path(path: String): FluentBuilder
        /**
         * The destination port for the health check request. This port must match the port defined
         * in the PortMapping for the listener.
         */
        fun port(port: Int): FluentBuilder
        /**
         * The protocol for the health check request. If you specify grpc, then your
         * service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
         * Checking Protocol.
         */
        fun protocol(protocol: PortProtocol): FluentBuilder
        /**
         * The amount of time to wait when receiving a response from the health check, in
         * milliseconds.
         */
        fun timeoutMillis(timeoutMillis: Long): FluentBuilder
        /**
         * The number of consecutive failed health checks that must occur before declaring a
         * virtual node unhealthy.
         */
        fun unhealthyThreshold(unhealthyThreshold: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of consecutive successful health checks that must occur before declaring
         * listener healthy.
         */
        var healthyThreshold: Int
        /**
         * The time period in milliseconds between each health check execution.
         */
        var intervalMillis: Long?
        /**
         * The destination path for the health check request. This value is only used if the
         * specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.
         */
        var path: String?
        /**
         * The destination port for the health check request. This port must match the port defined
         * in the PortMapping for the listener.
         */
        var port: Int
        /**
         * The protocol for the health check request. If you specify grpc, then your
         * service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health
         * Checking Protocol.
         */
        var protocol: PortProtocol?
        /**
         * The amount of time to wait when receiving a response from the health check, in
         * milliseconds.
         */
        var timeoutMillis: Long?
        /**
         * The number of consecutive failed health checks that must occur before declaring a
         * virtual node unhealthy.
         */
        var unhealthyThreshold: Int

        fun build(): HealthCheckPolicy
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var healthyThreshold: Int = 0
        override var intervalMillis: Long? = null
        override var path: String? = null
        override var port: Int = 0
        override var protocol: PortProtocol? = null
        override var timeoutMillis: Long? = null
        override var unhealthyThreshold: Int = 0

        constructor(x: HealthCheckPolicy) : this() {
            this.healthyThreshold = x.healthyThreshold
            this.intervalMillis = x.intervalMillis
            this.path = x.path
            this.port = x.port
            this.protocol = x.protocol
            this.timeoutMillis = x.timeoutMillis
            this.unhealthyThreshold = x.unhealthyThreshold
        }

        override fun build(): HealthCheckPolicy = HealthCheckPolicy(this)
        override fun healthyThreshold(healthyThreshold: Int): FluentBuilder = apply { this.healthyThreshold = healthyThreshold }
        override fun intervalMillis(intervalMillis: Long): FluentBuilder = apply { this.intervalMillis = intervalMillis }
        override fun path(path: String): FluentBuilder = apply { this.path = path }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun protocol(protocol: PortProtocol): FluentBuilder = apply { this.protocol = protocol }
        override fun timeoutMillis(timeoutMillis: Long): FluentBuilder = apply { this.timeoutMillis = timeoutMillis }
        override fun unhealthyThreshold(unhealthyThreshold: Int): FluentBuilder = apply { this.unhealthyThreshold = unhealthyThreshold }
    }
}
