// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the criteria for determining a request match.
 */
class HttpGatewayRouteMatch private constructor(builder: BuilderImpl) {
    /**
     * The client request headers to match on.
     */
    val headers: List<HttpGatewayRouteHeader>? = builder.headers
    /**
     * The host name to match on.
     */
    val hostname: GatewayRouteHostnameMatch? = builder.hostname
    /**
     * The method to match on.
     */
    val method: HttpMethod? = builder.method
    /**
     * The path to match on.
     */
    val path: HttpPathMatch? = builder.path
    /**
     * Specifies the path to match requests with. This parameter must always start with
     * /, which by itself matches all requests to the virtual service name. You
     * can also match for path-based routing of requests. For example, if your virtual service
     * name is my-service.local and you want the route to match requests to
     * my-service.local/metrics, your prefix should be
     * /metrics.
     */
    val prefix: String? = builder.prefix
    /**
     * The query parameter to match on.
     */
    val queryParameters: List<HttpQueryParameter>? = builder.queryParameters

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HttpGatewayRouteMatch = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HttpGatewayRouteMatch(")
        append("headers=$headers,")
        append("hostname=$hostname,")
        append("method=$method,")
        append("path=$path,")
        append("prefix=$prefix,")
        append("queryParameters=$queryParameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = headers?.hashCode() ?: 0
        result = 31 * result + (hostname?.hashCode() ?: 0)
        result = 31 * result + (method?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (queryParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HttpGatewayRouteMatch

        if (headers != other.headers) return false
        if (hostname != other.hostname) return false
        if (method != other.method) return false
        if (path != other.path) return false
        if (prefix != other.prefix) return false
        if (queryParameters != other.queryParameters) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HttpGatewayRouteMatch = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HttpGatewayRouteMatch
        /**
         * The client request headers to match on.
         */
        fun headers(headers: List<HttpGatewayRouteHeader>): FluentBuilder
        /**
         * The host name to match on.
         */
        fun hostname(hostname: GatewayRouteHostnameMatch): FluentBuilder
        /**
         * The method to match on.
         */
        fun method(method: HttpMethod): FluentBuilder
        /**
         * The path to match on.
         */
        fun path(path: HttpPathMatch): FluentBuilder
        /**
         * Specifies the path to match requests with. This parameter must always start with
         * /, which by itself matches all requests to the virtual service name. You
         * can also match for path-based routing of requests. For example, if your virtual service
         * name is my-service.local and you want the route to match requests to
         * my-service.local/metrics, your prefix should be
         * /metrics.
         */
        fun prefix(prefix: String): FluentBuilder
        /**
         * The query parameter to match on.
         */
        fun queryParameters(queryParameters: List<HttpQueryParameter>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The client request headers to match on.
         */
        var headers: List<HttpGatewayRouteHeader>?
        /**
         * The host name to match on.
         */
        var hostname: GatewayRouteHostnameMatch?
        /**
         * The method to match on.
         */
        var method: HttpMethod?
        /**
         * The path to match on.
         */
        var path: HttpPathMatch?
        /**
         * Specifies the path to match requests with. This parameter must always start with
         * /, which by itself matches all requests to the virtual service name. You
         * can also match for path-based routing of requests. For example, if your virtual service
         * name is my-service.local and you want the route to match requests to
         * my-service.local/metrics, your prefix should be
         * /metrics.
         */
        var prefix: String?
        /**
         * The query parameter to match on.
         */
        var queryParameters: List<HttpQueryParameter>?

        fun build(): HttpGatewayRouteMatch
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.GatewayRouteHostnameMatch] inside the given [block]
         */
        fun hostname(block: GatewayRouteHostnameMatch.DslBuilder.() -> kotlin.Unit) {
            this.hostname = GatewayRouteHostnameMatch.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.HttpPathMatch] inside the given [block]
         */
        fun path(block: HttpPathMatch.DslBuilder.() -> kotlin.Unit) {
            this.path = HttpPathMatch.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var headers: List<HttpGatewayRouteHeader>? = null
        override var hostname: GatewayRouteHostnameMatch? = null
        override var method: HttpMethod? = null
        override var path: HttpPathMatch? = null
        override var prefix: String? = null
        override var queryParameters: List<HttpQueryParameter>? = null

        constructor(x: HttpGatewayRouteMatch) : this() {
            this.headers = x.headers
            this.hostname = x.hostname
            this.method = x.method
            this.path = x.path
            this.prefix = x.prefix
            this.queryParameters = x.queryParameters
        }

        override fun build(): HttpGatewayRouteMatch = HttpGatewayRouteMatch(this)
        override fun headers(headers: List<HttpGatewayRouteHeader>): FluentBuilder = apply { this.headers = headers }
        override fun hostname(hostname: GatewayRouteHostnameMatch): FluentBuilder = apply { this.hostname = hostname }
        override fun method(method: HttpMethod): FluentBuilder = apply { this.method = method }
        override fun path(path: HttpPathMatch): FluentBuilder = apply { this.path = path }
        override fun prefix(prefix: String): FluentBuilder = apply { this.prefix = prefix }
        override fun queryParameters(queryParameters: List<HttpQueryParameter>): FluentBuilder = apply { this.queryParameters = queryParameters }
    }
}
