// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a retry policy. Specify at least one value for at least one of the types of RetryEvents, a value for maxRetries, and a value for perRetryTimeout.
 * Both server-error and gateway-error under httpRetryEvents include the Envoy reset policy. For more information on the
 * reset policy, see the <a href="https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on">Envoy documentation.
 */
class HttpRetryPolicy private constructor(builder: BuilderImpl) {
    /**
     * Specify at least one of the following values.
     * server-error – HTTP status codes 500, 501,
     * 502, 503, 504, 505, 506, 507, 508, 510, and 511
     * gateway-error – HTTP status codes 502,
     * 503, and 504
     * client-error – HTTP status code 409
     * stream-error – Retry on refused
     * stream
     */
    val httpRetryEvents: List<String>? = builder.httpRetryEvents
    /**
     * The maximum number of retry attempts.
     */
    val maxRetries: Long? = builder.maxRetries
    /**
     * The timeout for each retry attempt.
     */
    val perRetryTimeout: Duration? = builder.perRetryTimeout
    /**
     * Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.
     */
    val tcpRetryEvents: List<TcpRetryPolicyEvent>? = builder.tcpRetryEvents

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HttpRetryPolicy = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HttpRetryPolicy(")
        append("httpRetryEvents=$httpRetryEvents,")
        append("maxRetries=$maxRetries,")
        append("perRetryTimeout=$perRetryTimeout,")
        append("tcpRetryEvents=$tcpRetryEvents)")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpRetryEvents?.hashCode() ?: 0
        result = 31 * result + (maxRetries?.hashCode() ?: 0)
        result = 31 * result + (perRetryTimeout?.hashCode() ?: 0)
        result = 31 * result + (tcpRetryEvents?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HttpRetryPolicy

        if (httpRetryEvents != other.httpRetryEvents) return false
        if (maxRetries != other.maxRetries) return false
        if (perRetryTimeout != other.perRetryTimeout) return false
        if (tcpRetryEvents != other.tcpRetryEvents) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HttpRetryPolicy = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HttpRetryPolicy
        /**
         * Specify at least one of the following values.
         * server-error – HTTP status codes 500, 501,
         * 502, 503, 504, 505, 506, 507, 508, 510, and 511
         * gateway-error – HTTP status codes 502,
         * 503, and 504
         * client-error – HTTP status code 409
         * stream-error – Retry on refused
         * stream
         */
        fun httpRetryEvents(httpRetryEvents: List<String>): FluentBuilder
        /**
         * The maximum number of retry attempts.
         */
        fun maxRetries(maxRetries: Long): FluentBuilder
        /**
         * The timeout for each retry attempt.
         */
        fun perRetryTimeout(perRetryTimeout: Duration): FluentBuilder
        /**
         * Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.
         */
        fun tcpRetryEvents(tcpRetryEvents: List<TcpRetryPolicyEvent>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specify at least one of the following values.
         * server-error – HTTP status codes 500, 501,
         * 502, 503, 504, 505, 506, 507, 508, 510, and 511
         * gateway-error – HTTP status codes 502,
         * 503, and 504
         * client-error – HTTP status code 409
         * stream-error – Retry on refused
         * stream
         */
        var httpRetryEvents: List<String>?
        /**
         * The maximum number of retry attempts.
         */
        var maxRetries: Long?
        /**
         * The timeout for each retry attempt.
         */
        var perRetryTimeout: Duration?
        /**
         * Specify a valid value. The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.
         */
        var tcpRetryEvents: List<TcpRetryPolicyEvent>?

        fun build(): HttpRetryPolicy
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.Duration] inside the given [block]
         */
        fun perRetryTimeout(block: Duration.DslBuilder.() -> kotlin.Unit) {
            this.perRetryTimeout = Duration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var httpRetryEvents: List<String>? = null
        override var maxRetries: Long? = null
        override var perRetryTimeout: Duration? = null
        override var tcpRetryEvents: List<TcpRetryPolicyEvent>? = null

        constructor(x: HttpRetryPolicy) : this() {
            this.httpRetryEvents = x.httpRetryEvents
            this.maxRetries = x.maxRetries
            this.perRetryTimeout = x.perRetryTimeout
            this.tcpRetryEvents = x.tcpRetryEvents
        }

        override fun build(): HttpRetryPolicy = HttpRetryPolicy(this)
        override fun httpRetryEvents(httpRetryEvents: List<String>): FluentBuilder = apply { this.httpRetryEvents = httpRetryEvents }
        override fun maxRetries(maxRetries: Long): FluentBuilder = apply { this.maxRetries = maxRetries }
        override fun perRetryTimeout(perRetryTimeout: Duration): FluentBuilder = apply { this.perRetryTimeout = perRetryTimeout }
        override fun tcpRetryEvents(tcpRetryEvents: List<TcpRetryPolicyEvent>): FluentBuilder = apply { this.tcpRetryEvents = tcpRetryEvents }
    }
}
