// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the requirements for a route to match HTTP requests for a
 * virtual router.
 */
class HttpRouteMatch private constructor(builder: BuilderImpl) {
    /**
     * The client request headers to match on.
     */
    val headers: List<HttpRouteHeader>? = builder.headers
    /**
     * The client request method to match on. Specify only one.
     */
    val method: HttpMethod? = builder.method
    /**
     * The client request path to match on.
     */
    val path: HttpPathMatch? = builder.path
    /**
     * Specifies the path to match requests with. This parameter must always start with
     * /, which by itself matches all requests to the virtual service name. You
     * can also match for path-based routing of requests. For example, if your virtual service
     * name is my-service.local and you want the route to match requests to
     * my-service.local/metrics, your prefix should be
     * /metrics.
     */
    val prefix: String? = builder.prefix
    /**
     * The client request query parameters to match on.
     */
    val queryParameters: List<HttpQueryParameter>? = builder.queryParameters
    /**
     * The client request scheme to match on. Specify only one. Applicable only for HTTP2
     * routes.
     */
    val scheme: HttpScheme? = builder.scheme

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HttpRouteMatch = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HttpRouteMatch(")
        append("headers=$headers,")
        append("method=$method,")
        append("path=$path,")
        append("prefix=$prefix,")
        append("queryParameters=$queryParameters,")
        append("scheme=$scheme)")
    }

    override fun hashCode(): kotlin.Int {
        var result = headers?.hashCode() ?: 0
        result = 31 * result + (method?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (queryParameters?.hashCode() ?: 0)
        result = 31 * result + (scheme?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HttpRouteMatch

        if (headers != other.headers) return false
        if (method != other.method) return false
        if (path != other.path) return false
        if (prefix != other.prefix) return false
        if (queryParameters != other.queryParameters) return false
        if (scheme != other.scheme) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HttpRouteMatch = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HttpRouteMatch
        /**
         * The client request headers to match on.
         */
        fun headers(headers: List<HttpRouteHeader>): FluentBuilder
        /**
         * The client request method to match on. Specify only one.
         */
        fun method(method: HttpMethod): FluentBuilder
        /**
         * The client request path to match on.
         */
        fun path(path: HttpPathMatch): FluentBuilder
        /**
         * Specifies the path to match requests with. This parameter must always start with
         * /, which by itself matches all requests to the virtual service name. You
         * can also match for path-based routing of requests. For example, if your virtual service
         * name is my-service.local and you want the route to match requests to
         * my-service.local/metrics, your prefix should be
         * /metrics.
         */
        fun prefix(prefix: String): FluentBuilder
        /**
         * The client request query parameters to match on.
         */
        fun queryParameters(queryParameters: List<HttpQueryParameter>): FluentBuilder
        /**
         * The client request scheme to match on. Specify only one. Applicable only for HTTP2
         * routes.
         */
        fun scheme(scheme: HttpScheme): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The client request headers to match on.
         */
        var headers: List<HttpRouteHeader>?
        /**
         * The client request method to match on. Specify only one.
         */
        var method: HttpMethod?
        /**
         * The client request path to match on.
         */
        var path: HttpPathMatch?
        /**
         * Specifies the path to match requests with. This parameter must always start with
         * /, which by itself matches all requests to the virtual service name. You
         * can also match for path-based routing of requests. For example, if your virtual service
         * name is my-service.local and you want the route to match requests to
         * my-service.local/metrics, your prefix should be
         * /metrics.
         */
        var prefix: String?
        /**
         * The client request query parameters to match on.
         */
        var queryParameters: List<HttpQueryParameter>?
        /**
         * The client request scheme to match on. Specify only one. Applicable only for HTTP2
         * routes.
         */
        var scheme: HttpScheme?

        fun build(): HttpRouteMatch
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.HttpPathMatch] inside the given [block]
         */
        fun path(block: HttpPathMatch.DslBuilder.() -> kotlin.Unit) {
            this.path = HttpPathMatch.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var headers: List<HttpRouteHeader>? = null
        override var method: HttpMethod? = null
        override var path: HttpPathMatch? = null
        override var prefix: String? = null
        override var queryParameters: List<HttpQueryParameter>? = null
        override var scheme: HttpScheme? = null

        constructor(x: HttpRouteMatch) : this() {
            this.headers = x.headers
            this.method = x.method
            this.path = x.path
            this.prefix = x.prefix
            this.queryParameters = x.queryParameters
            this.scheme = x.scheme
        }

        override fun build(): HttpRouteMatch = HttpRouteMatch(this)
        override fun headers(headers: List<HttpRouteHeader>): FluentBuilder = apply { this.headers = headers }
        override fun method(method: HttpMethod): FluentBuilder = apply { this.method = method }
        override fun path(path: HttpPathMatch): FluentBuilder = apply { this.path = path }
        override fun prefix(prefix: String): FluentBuilder = apply { this.prefix = prefix }
        override fun queryParameters(queryParameters: List<HttpQueryParameter>): FluentBuilder = apply { this.queryParameters = queryParameters }
        override fun scheme(scheme: HttpScheme): FluentBuilder = apply { this.scheme = scheme }
    }
}
