// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



class ListGatewayRoutesRequest private constructor(builder: BuilderImpl) {
    /**
     * The maximum number of results returned by ListGatewayRoutes in paginated
     * output. When you use this parameter, ListGatewayRoutes returns only
     * limit results in a single page along with a nextToken response
     * element. You can see the remaining results of the initial request by sending another
     * ListGatewayRoutes request with the returned nextToken value.
     * This value can be between 1 and 100. If you don't use this
     * parameter, ListGatewayRoutes returns up to 100 results and a
     * nextToken value if applicable.
     */
    val limit: Int? = builder.limit
    /**
     * The name of the service mesh to list gateway routes in.
     */
    val meshName: String? = builder.meshName
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: String? = builder.meshOwner
    /**
     * The nextToken value returned from a previous paginated
     * ListGatewayRoutes request where limit was used and the results
     * exceeded the value of that parameter. Pagination continues from the end of the previous
     * results that returned the nextToken value.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The name of the virtual gateway to list gateway routes in.
     */
    val virtualGatewayName: String? = builder.virtualGatewayName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListGatewayRoutesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListGatewayRoutesRequest(")
        append("limit=$limit,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("nextToken=$nextToken,")
        append("virtualGatewayName=$virtualGatewayName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListGatewayRoutesRequest

        if (limit != other.limit) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (nextToken != other.nextToken) return false
        if (virtualGatewayName != other.virtualGatewayName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListGatewayRoutesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListGatewayRoutesRequest
        /**
         * The maximum number of results returned by ListGatewayRoutes in paginated
         * output. When you use this parameter, ListGatewayRoutes returns only
         * limit results in a single page along with a nextToken response
         * element. You can see the remaining results of the initial request by sending another
         * ListGatewayRoutes request with the returned nextToken value.
         * This value can be between 1 and 100. If you don't use this
         * parameter, ListGatewayRoutes returns up to 100 results and a
         * nextToken value if applicable.
         */
        fun limit(limit: Int): FluentBuilder
        /**
         * The name of the service mesh to list gateway routes in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun meshOwner(meshOwner: String): FluentBuilder
        /**
         * The nextToken value returned from a previous paginated
         * ListGatewayRoutes request where limit was used and the results
         * exceeded the value of that parameter. Pagination continues from the end of the previous
         * results that returned the nextToken value.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The name of the virtual gateway to list gateway routes in.
         */
        fun virtualGatewayName(virtualGatewayName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The maximum number of results returned by ListGatewayRoutes in paginated
         * output. When you use this parameter, ListGatewayRoutes returns only
         * limit results in a single page along with a nextToken response
         * element. You can see the remaining results of the initial request by sending another
         * ListGatewayRoutes request with the returned nextToken value.
         * This value can be between 1 and 100. If you don't use this
         * parameter, ListGatewayRoutes returns up to 100 results and a
         * nextToken value if applicable.
         */
        var limit: Int?
        /**
         * The name of the service mesh to list gateway routes in.
         */
        var meshName: String?
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: String?
        /**
         * The nextToken value returned from a previous paginated
         * ListGatewayRoutes request where limit was used and the results
         * exceeded the value of that parameter. Pagination continues from the end of the previous
         * results that returned the nextToken value.
         */
        var nextToken: String?
        /**
         * The name of the virtual gateway to list gateway routes in.
         */
        var virtualGatewayName: String?

        fun build(): ListGatewayRoutesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var limit: Int? = null
        override var meshName: String? = null
        override var meshOwner: String? = null
        override var nextToken: String? = null
        override var virtualGatewayName: String? = null

        constructor(x: ListGatewayRoutesRequest) : this() {
            this.limit = x.limit
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.nextToken = x.nextToken
            this.virtualGatewayName = x.virtualGatewayName
        }

        override fun build(): ListGatewayRoutesRequest = ListGatewayRoutesRequest(this)
        override fun limit(limit: Int): FluentBuilder = apply { this.limit = limit }
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun meshOwner(meshOwner: String): FluentBuilder = apply { this.meshOwner = meshOwner }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun virtualGatewayName(virtualGatewayName: String): FluentBuilder = apply { this.virtualGatewayName = virtualGatewayName }
    }
}
