// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 *
 */
class ListTagsForResourceRequest private constructor(builder: BuilderImpl) {
    /**
     * The maximum number of tag results returned by ListTagsForResource in
     * paginated output. When this parameter is used, ListTagsForResource returns
     * only limit results in a single page along with a nextToken
     * response element. You can see the remaining results of the initial request by sending
     * another ListTagsForResource request with the returned nextToken
     * value. This value can be between 1 and 100. If you don't use
     * this parameter, ListTagsForResource returns up to 100
     * results and a nextToken value if applicable.
     */
    val limit: Int? = builder.limit
    /**
     * The nextToken value returned from a previous paginated
     * ListTagsForResource request where limit was used and the
     * results exceeded the value of that parameter. Pagination continues from the end of the
     * previous results that returned the nextToken value.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The Amazon Resource Name (ARN) that identifies the resource to list the tags for.
     */
    val resourceArn: String? = builder.resourceArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListTagsForResourceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListTagsForResourceRequest(")
        append("limit=$limit,")
        append("nextToken=$nextToken,")
        append("resourceArn=$resourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListTagsForResourceRequest

        if (limit != other.limit) return false
        if (nextToken != other.nextToken) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListTagsForResourceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListTagsForResourceRequest
        /**
         * The maximum number of tag results returned by ListTagsForResource in
         * paginated output. When this parameter is used, ListTagsForResource returns
         * only limit results in a single page along with a nextToken
         * response element. You can see the remaining results of the initial request by sending
         * another ListTagsForResource request with the returned nextToken
         * value. This value can be between 1 and 100. If you don't use
         * this parameter, ListTagsForResource returns up to 100
         * results and a nextToken value if applicable.
         */
        fun limit(limit: Int): FluentBuilder
        /**
         * The nextToken value returned from a previous paginated
         * ListTagsForResource request where limit was used and the
         * results exceeded the value of that parameter. Pagination continues from the end of the
         * previous results that returned the nextToken value.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) that identifies the resource to list the tags for.
         */
        fun resourceArn(resourceArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The maximum number of tag results returned by ListTagsForResource in
         * paginated output. When this parameter is used, ListTagsForResource returns
         * only limit results in a single page along with a nextToken
         * response element. You can see the remaining results of the initial request by sending
         * another ListTagsForResource request with the returned nextToken
         * value. This value can be between 1 and 100. If you don't use
         * this parameter, ListTagsForResource returns up to 100
         * results and a nextToken value if applicable.
         */
        var limit: Int?
        /**
         * The nextToken value returned from a previous paginated
         * ListTagsForResource request where limit was used and the
         * results exceeded the value of that parameter. Pagination continues from the end of the
         * previous results that returned the nextToken value.
         */
        var nextToken: String?
        /**
         * The Amazon Resource Name (ARN) that identifies the resource to list the tags for.
         */
        var resourceArn: String?

        fun build(): ListTagsForResourceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var limit: Int? = null
        override var nextToken: String? = null
        override var resourceArn: String? = null

        constructor(x: ListTagsForResourceRequest) : this() {
            this.limit = x.limit
            this.nextToken = x.nextToken
            this.resourceArn = x.resourceArn
        }

        override fun build(): ListTagsForResourceRequest = ListTagsForResourceRequest(this)
        override fun limit(limit: Int): FluentBuilder = apply { this.limit = limit }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun resourceArn(resourceArn: String): FluentBuilder = apply { this.resourceArn = resourceArn }
    }
}
