// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the Transport Layer Security (TLS) properties for a listener.
 */
class ListenerTls private constructor(builder: BuilderImpl) {
    /**
     * A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.
     */
    val certificate: ListenerTlsCertificate? = builder.certificate
    /**
     * Specify one of the following modes.
     * <b/>STRICT – Listener only accepts connections with TLS
     * enabled.
     * <b/>PERMISSIVE – Listener accepts connections with or
     * without TLS enabled.
     * <b/>DISABLED – Listener only accepts connections without
     * TLS.
     */
    val mode: ListenerTlsMode? = builder.mode
    /**
     * A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
     */
    val validation: ListenerTlsValidationContext? = builder.validation

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListenerTls = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListenerTls(")
        append("certificate=$certificate,")
        append("mode=$mode,")
        append("validation=$validation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.hashCode() ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (validation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListenerTls

        if (certificate != other.certificate) return false
        if (mode != other.mode) return false
        if (validation != other.validation) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListenerTls = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListenerTls
        /**
         * A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.
         */
        fun certificate(certificate: ListenerTlsCertificate): FluentBuilder
        /**
         * Specify one of the following modes.
         * <b/>STRICT – Listener only accepts connections with TLS
         * enabled.
         * <b/>PERMISSIVE – Listener accepts connections with or
         * without TLS enabled.
         * <b/>DISABLED – Listener only accepts connections without
         * TLS.
         */
        fun mode(mode: ListenerTlsMode): FluentBuilder
        /**
         * A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
         */
        fun validation(validation: ListenerTlsValidationContext): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A reference to an object that represents a listener's Transport Layer Security (TLS) certificate.
         */
        var certificate: ListenerTlsCertificate?
        /**
         * Specify one of the following modes.
         * <b/>STRICT – Listener only accepts connections with TLS
         * enabled.
         * <b/>PERMISSIVE – Listener accepts connections with or
         * without TLS enabled.
         * <b/>DISABLED – Listener only accepts connections without
         * TLS.
         */
        var mode: ListenerTlsMode?
        /**
         * A reference to an object that represents a listener's Transport Layer Security (TLS) validation context.
         */
        var validation: ListenerTlsValidationContext?

        fun build(): ListenerTls
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.ListenerTlsValidationContext] inside the given [block]
         */
        fun validation(block: ListenerTlsValidationContext.DslBuilder.() -> kotlin.Unit) {
            this.validation = ListenerTlsValidationContext.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificate: ListenerTlsCertificate? = null
        override var mode: ListenerTlsMode? = null
        override var validation: ListenerTlsValidationContext? = null

        constructor(x: ListenerTls) : this() {
            this.certificate = x.certificate
            this.mode = x.mode
            this.validation = x.validation
        }

        override fun build(): ListenerTls = ListenerTls(this)
        override fun certificate(certificate: ListenerTlsCertificate): FluentBuilder = apply { this.certificate = certificate }
        override fun mode(mode: ListenerTlsMode): FluentBuilder = apply { this.mode = mode }
        override fun validation(validation: ListenerTlsValidationContext): FluentBuilder = apply { this.validation = validation }
    }
}
