// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the outlier detection for a virtual node's listener.
 */
class OutlierDetection private constructor(builder: BuilderImpl) {
    /**
     * The base amount of time for which a host is ejected.
     */
    val baseEjectionDuration: Duration? = builder.baseEjectionDuration
    /**
     * The time interval between ejection sweep analysis.
     */
    val interval: Duration? = builder.interval
    /**
     * Maximum percentage of hosts in load balancing pool for upstream service that can be
     * ejected. Will eject at least one host regardless of the value.
     */
    val maxEjectionPercent: Int? = builder.maxEjectionPercent
    /**
     * Number of consecutive 5xx errors required for ejection.
     */
    val maxServerErrors: Long? = builder.maxServerErrors

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OutlierDetection = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OutlierDetection(")
        append("baseEjectionDuration=$baseEjectionDuration,")
        append("interval=$interval,")
        append("maxEjectionPercent=$maxEjectionPercent,")
        append("maxServerErrors=$maxServerErrors)")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseEjectionDuration?.hashCode() ?: 0
        result = 31 * result + (interval?.hashCode() ?: 0)
        result = 31 * result + (maxEjectionPercent ?: 0)
        result = 31 * result + (maxServerErrors?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OutlierDetection

        if (baseEjectionDuration != other.baseEjectionDuration) return false
        if (interval != other.interval) return false
        if (maxEjectionPercent != other.maxEjectionPercent) return false
        if (maxServerErrors != other.maxServerErrors) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OutlierDetection = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OutlierDetection
        /**
         * The base amount of time for which a host is ejected.
         */
        fun baseEjectionDuration(baseEjectionDuration: Duration): FluentBuilder
        /**
         * The time interval between ejection sweep analysis.
         */
        fun interval(interval: Duration): FluentBuilder
        /**
         * Maximum percentage of hosts in load balancing pool for upstream service that can be
         * ejected. Will eject at least one host regardless of the value.
         */
        fun maxEjectionPercent(maxEjectionPercent: Int): FluentBuilder
        /**
         * Number of consecutive 5xx errors required for ejection.
         */
        fun maxServerErrors(maxServerErrors: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The base amount of time for which a host is ejected.
         */
        var baseEjectionDuration: Duration?
        /**
         * The time interval between ejection sweep analysis.
         */
        var interval: Duration?
        /**
         * Maximum percentage of hosts in load balancing pool for upstream service that can be
         * ejected. Will eject at least one host regardless of the value.
         */
        var maxEjectionPercent: Int?
        /**
         * Number of consecutive 5xx errors required for ejection.
         */
        var maxServerErrors: Long?

        fun build(): OutlierDetection
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.Duration] inside the given [block]
         */
        fun baseEjectionDuration(block: Duration.DslBuilder.() -> kotlin.Unit) {
            this.baseEjectionDuration = Duration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.Duration] inside the given [block]
         */
        fun interval(block: Duration.DslBuilder.() -> kotlin.Unit) {
            this.interval = Duration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var baseEjectionDuration: Duration? = null
        override var interval: Duration? = null
        override var maxEjectionPercent: Int? = null
        override var maxServerErrors: Long? = null

        constructor(x: OutlierDetection) : this() {
            this.baseEjectionDuration = x.baseEjectionDuration
            this.interval = x.interval
            this.maxEjectionPercent = x.maxEjectionPercent
            this.maxServerErrors = x.maxServerErrors
        }

        override fun build(): OutlierDetection = OutlierDetection(this)
        override fun baseEjectionDuration(baseEjectionDuration: Duration): FluentBuilder = apply { this.baseEjectionDuration = baseEjectionDuration }
        override fun interval(interval: Duration): FluentBuilder = apply { this.interval = interval }
        override fun maxEjectionPercent(maxEjectionPercent: Int): FluentBuilder = apply { this.maxEjectionPercent = maxEjectionPercent }
        override fun maxServerErrors(maxServerErrors: Long): FluentBuilder = apply { this.maxServerErrors = maxServerErrors }
    }
}
