// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that represents metadata for a resource.
 */
class ResourceMetadata private constructor(builder: BuilderImpl) {
    /**
     * The full Amazon Resource Name (ARN) for the resource.
     */
    val arn: String? = builder.arn
    /**
     * The Unix epoch timestamp in seconds for when the resource was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The Unix epoch timestamp in seconds for when the resource was last updated.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: String? = builder.meshOwner
    /**
     * The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
     * the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val resourceOwner: String? = builder.resourceOwner
    /**
     * The unique identifier for the resource.
     */
    val uid: String? = builder.uid
    /**
     * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
     */
    val version: Long? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ResourceMetadata = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceMetadata(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("meshOwner=$meshOwner,")
        append("resourceOwner=$resourceOwner,")
        append("uid=$uid,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (resourceOwner?.hashCode() ?: 0)
        result = 31 * result + (uid?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ResourceMetadata

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (meshOwner != other.meshOwner) return false
        if (resourceOwner != other.resourceOwner) return false
        if (uid != other.uid) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ResourceMetadata = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ResourceMetadata
        /**
         * The full Amazon Resource Name (ARN) for the resource.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The Unix epoch timestamp in seconds for when the resource was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The Unix epoch timestamp in seconds for when the resource was last updated.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun meshOwner(meshOwner: String): FluentBuilder
        /**
         * The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
         * the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun resourceOwner(resourceOwner: String): FluentBuilder
        /**
         * The unique identifier for the resource.
         */
        fun uid(uid: String): FluentBuilder
        /**
         * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
         */
        fun version(version: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The full Amazon Resource Name (ARN) for the resource.
         */
        var arn: String?
        /**
         * The Unix epoch timestamp in seconds for when the resource was created.
         */
        var createdAt: Instant?
        /**
         * The Unix epoch timestamp in seconds for when the resource was last updated.
         */
        var lastUpdatedAt: Instant?
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: String?
        /**
         * The AWS IAM account ID of the resource owner. If the account ID is not your own, then it's
         * the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var resourceOwner: String?
        /**
         * The unique identifier for the resource.
         */
        var uid: String?
        /**
         * The version of the resource. Resources are created at version 1, and this version is incremented each time that they're updated.
         */
        var version: Long?

        fun build(): ResourceMetadata
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var createdAt: Instant? = null
        override var lastUpdatedAt: Instant? = null
        override var meshOwner: String? = null
        override var resourceOwner: String? = null
        override var uid: String? = null
        override var version: Long? = null

        constructor(x: ResourceMetadata) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.lastUpdatedAt = x.lastUpdatedAt
            this.meshOwner = x.meshOwner
            this.resourceOwner = x.resourceOwner
            this.uid = x.uid
            this.version = x.version
        }

        override fun build(): ResourceMetadata = ResourceMetadata(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun meshOwner(meshOwner: String): FluentBuilder = apply { this.meshOwner = meshOwner }
        override fun resourceOwner(resourceOwner: String): FluentBuilder = apply { this.resourceOwner = resourceOwner }
        override fun uid(uid: String): FluentBuilder = apply { this.uid = uid }
        override fun version(version: Long): FluentBuilder = apply { this.version = version }
    }
}
