// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a route returned by a describe operation.
 */
class RouteData private constructor(builder: BuilderImpl) {
    /**
     * The name of the service mesh that the route resides in.
     */
    val meshName: String? = builder.meshName
    /**
     * The associated metadata for the route.
     */
    val metadata: ResourceMetadata? = builder.metadata
    /**
     * The name of the route.
     */
    val routeName: String? = builder.routeName
    /**
     * The specifications of the route.
     */
    val spec: RouteSpec? = builder.spec
    /**
     * The status of the route.
     */
    val status: RouteStatus? = builder.status
    /**
     * The virtual router that the route is associated with.
     */
    val virtualRouterName: String? = builder.virtualRouterName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RouteData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RouteData(")
        append("meshName=$meshName,")
        append("metadata=$metadata,")
        append("routeName=$routeName,")
        append("spec=$spec,")
        append("status=$status,")
        append("virtualRouterName=$virtualRouterName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = meshName?.hashCode() ?: 0
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (routeName?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (virtualRouterName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RouteData

        if (meshName != other.meshName) return false
        if (metadata != other.metadata) return false
        if (routeName != other.routeName) return false
        if (spec != other.spec) return false
        if (status != other.status) return false
        if (virtualRouterName != other.virtualRouterName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RouteData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RouteData
        /**
         * The name of the service mesh that the route resides in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The associated metadata for the route.
         */
        fun metadata(metadata: ResourceMetadata): FluentBuilder
        /**
         * The name of the route.
         */
        fun routeName(routeName: String): FluentBuilder
        /**
         * The specifications of the route.
         */
        fun spec(spec: RouteSpec): FluentBuilder
        /**
         * The status of the route.
         */
        fun status(status: RouteStatus): FluentBuilder
        /**
         * The virtual router that the route is associated with.
         */
        fun virtualRouterName(virtualRouterName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the service mesh that the route resides in.
         */
        var meshName: String?
        /**
         * The associated metadata for the route.
         */
        var metadata: ResourceMetadata?
        /**
         * The name of the route.
         */
        var routeName: String?
        /**
         * The specifications of the route.
         */
        var spec: RouteSpec?
        /**
         * The status of the route.
         */
        var status: RouteStatus?
        /**
         * The virtual router that the route is associated with.
         */
        var virtualRouterName: String?

        fun build(): RouteData
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.ResourceMetadata] inside the given [block]
         */
        fun metadata(block: ResourceMetadata.DslBuilder.() -> kotlin.Unit) {
            this.metadata = ResourceMetadata.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.RouteSpec] inside the given [block]
         */
        fun spec(block: RouteSpec.DslBuilder.() -> kotlin.Unit) {
            this.spec = RouteSpec.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.RouteStatus] inside the given [block]
         */
        fun status(block: RouteStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = RouteStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var meshName: String? = null
        override var metadata: ResourceMetadata? = null
        override var routeName: String? = null
        override var spec: RouteSpec? = null
        override var status: RouteStatus? = null
        override var virtualRouterName: String? = null

        constructor(x: RouteData) : this() {
            this.meshName = x.meshName
            this.metadata = x.metadata
            this.routeName = x.routeName
            this.spec = x.spec
            this.status = x.status
            this.virtualRouterName = x.virtualRouterName
        }

        override fun build(): RouteData = RouteData(this)
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun metadata(metadata: ResourceMetadata): FluentBuilder = apply { this.metadata = metadata }
        override fun routeName(routeName: String): FluentBuilder = apply { this.routeName = routeName }
        override fun spec(spec: RouteSpec): FluentBuilder = apply { this.spec = spec }
        override fun status(status: RouteStatus): FluentBuilder = apply { this.status = status }
        override fun virtualRouterName(virtualRouterName: String): FluentBuilder = apply { this.virtualRouterName = virtualRouterName }
    }
}
