// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a route specification. Specify one route type.
 */
class RouteSpec private constructor(builder: BuilderImpl) {
    /**
     * An object that represents the specification of a gRPC route.
     */
    val grpcRoute: GrpcRoute? = builder.grpcRoute
    /**
     * An object that represents the specification of an HTTP/2 route.
     */
    val http2Route: HttpRoute? = builder.http2Route
    /**
     * An object that represents the specification of an HTTP route.
     */
    val httpRoute: HttpRoute? = builder.httpRoute
    /**
     * The priority for the route. Routes are matched based on the specified value, where 0 is
     * the highest priority.
     */
    val priority: Int? = builder.priority
    /**
     * An object that represents the specification of a TCP route.
     */
    val tcpRoute: TcpRoute? = builder.tcpRoute

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RouteSpec = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RouteSpec(")
        append("grpcRoute=$grpcRoute,")
        append("http2Route=$http2Route,")
        append("httpRoute=$httpRoute,")
        append("priority=$priority,")
        append("tcpRoute=$tcpRoute)")
    }

    override fun hashCode(): kotlin.Int {
        var result = grpcRoute?.hashCode() ?: 0
        result = 31 * result + (http2Route?.hashCode() ?: 0)
        result = 31 * result + (httpRoute?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (tcpRoute?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RouteSpec

        if (grpcRoute != other.grpcRoute) return false
        if (http2Route != other.http2Route) return false
        if (httpRoute != other.httpRoute) return false
        if (priority != other.priority) return false
        if (tcpRoute != other.tcpRoute) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RouteSpec = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RouteSpec
        /**
         * An object that represents the specification of a gRPC route.
         */
        fun grpcRoute(grpcRoute: GrpcRoute): FluentBuilder
        /**
         * An object that represents the specification of an HTTP/2 route.
         */
        fun http2Route(http2Route: HttpRoute): FluentBuilder
        /**
         * An object that represents the specification of an HTTP route.
         */
        fun httpRoute(httpRoute: HttpRoute): FluentBuilder
        /**
         * The priority for the route. Routes are matched based on the specified value, where 0 is
         * the highest priority.
         */
        fun priority(priority: Int): FluentBuilder
        /**
         * An object that represents the specification of a TCP route.
         */
        fun tcpRoute(tcpRoute: TcpRoute): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An object that represents the specification of a gRPC route.
         */
        var grpcRoute: GrpcRoute?
        /**
         * An object that represents the specification of an HTTP/2 route.
         */
        var http2Route: HttpRoute?
        /**
         * An object that represents the specification of an HTTP route.
         */
        var httpRoute: HttpRoute?
        /**
         * The priority for the route. Routes are matched based on the specified value, where 0 is
         * the highest priority.
         */
        var priority: Int?
        /**
         * An object that represents the specification of a TCP route.
         */
        var tcpRoute: TcpRoute?

        fun build(): RouteSpec
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.GrpcRoute] inside the given [block]
         */
        fun grpcRoute(block: GrpcRoute.DslBuilder.() -> kotlin.Unit) {
            this.grpcRoute = GrpcRoute.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.HttpRoute] inside the given [block]
         */
        fun http2Route(block: HttpRoute.DslBuilder.() -> kotlin.Unit) {
            this.http2Route = HttpRoute.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.HttpRoute] inside the given [block]
         */
        fun httpRoute(block: HttpRoute.DslBuilder.() -> kotlin.Unit) {
            this.httpRoute = HttpRoute.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.TcpRoute] inside the given [block]
         */
        fun tcpRoute(block: TcpRoute.DslBuilder.() -> kotlin.Unit) {
            this.tcpRoute = TcpRoute.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var grpcRoute: GrpcRoute? = null
        override var http2Route: HttpRoute? = null
        override var httpRoute: HttpRoute? = null
        override var priority: Int? = null
        override var tcpRoute: TcpRoute? = null

        constructor(x: RouteSpec) : this() {
            this.grpcRoute = x.grpcRoute
            this.http2Route = x.http2Route
            this.httpRoute = x.httpRoute
            this.priority = x.priority
            this.tcpRoute = x.tcpRoute
        }

        override fun build(): RouteSpec = RouteSpec(this)
        override fun grpcRoute(grpcRoute: GrpcRoute): FluentBuilder = apply { this.grpcRoute = grpcRoute }
        override fun http2Route(http2Route: HttpRoute): FluentBuilder = apply { this.http2Route = http2Route }
        override fun httpRoute(httpRoute: HttpRoute): FluentBuilder = apply { this.httpRoute = httpRoute }
        override fun priority(priority: Int): FluentBuilder = apply { this.priority = priority }
        override fun tcpRoute(tcpRoute: TcpRoute): FluentBuilder = apply { this.tcpRoute = tcpRoute }
    }
}
