// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a Transport Layer Security (TLS) Secret Discovery Service validation context trust. The
 * proxy must be configured with a local SDS provider via a Unix Domain Socket. See App Mesh
 * <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">TLS
 * documentation for more info.
 */
class TlsValidationContextSdsTrust private constructor(builder: BuilderImpl) {
    /**
     * A reference to an object that represents the name of the secret for a Transport Layer Security (TLS) Secret
     * Discovery Service validation context trust.
     */
    val secretName: String? = builder.secretName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TlsValidationContextSdsTrust = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TlsValidationContextSdsTrust(")
        append("secretName=$secretName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = secretName?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TlsValidationContextSdsTrust

        if (secretName != other.secretName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TlsValidationContextSdsTrust = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TlsValidationContextSdsTrust
        /**
         * A reference to an object that represents the name of the secret for a Transport Layer Security (TLS) Secret
         * Discovery Service validation context trust.
         */
        fun secretName(secretName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A reference to an object that represents the name of the secret for a Transport Layer Security (TLS) Secret
         * Discovery Service validation context trust.
         */
        var secretName: String?

        fun build(): TlsValidationContextSdsTrust
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var secretName: String? = null

        constructor(x: TlsValidationContextSdsTrust) : this() {
            this.secretName = x.secretName
        }

        override fun build(): TlsValidationContextSdsTrust = TlsValidationContextSdsTrust(this)
        override fun secretName(secretName: String): FluentBuilder = apply { this.secretName = secretName }
    }
}
