// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



class UpdateGatewayRouteRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The name of the gateway route to update.
     */
    val gatewayRouteName: String? = builder.gatewayRouteName
    /**
     * The name of the service mesh that the gateway route resides in.
     */
    val meshName: String? = builder.meshName
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: String? = builder.meshOwner
    /**
     * The new gateway route specification to apply. This overwrites the existing data.
     */
    val spec: GatewayRouteSpec? = builder.spec
    /**
     * The name of the virtual gateway that the gateway route is associated with.
     */
    val virtualGatewayName: String? = builder.virtualGatewayName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateGatewayRouteRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateGatewayRouteRequest(")
        append("clientToken=$clientToken,")
        append("gatewayRouteName=$gatewayRouteName,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("spec=$spec,")
        append("virtualGatewayName=$virtualGatewayName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (gatewayRouteName?.hashCode() ?: 0)
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateGatewayRouteRequest

        if (clientToken != other.clientToken) return false
        if (gatewayRouteName != other.gatewayRouteName) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (spec != other.spec) return false
        if (virtualGatewayName != other.virtualGatewayName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateGatewayRouteRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateGatewayRouteRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The name of the gateway route to update.
         */
        fun gatewayRouteName(gatewayRouteName: String): FluentBuilder
        /**
         * The name of the service mesh that the gateway route resides in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun meshOwner(meshOwner: String): FluentBuilder
        /**
         * The new gateway route specification to apply. This overwrites the existing data.
         */
        fun spec(spec: GatewayRouteSpec): FluentBuilder
        /**
         * The name of the virtual gateway that the gateway route is associated with.
         */
        fun virtualGatewayName(virtualGatewayName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        var clientToken: String?
        /**
         * The name of the gateway route to update.
         */
        var gatewayRouteName: String?
        /**
         * The name of the service mesh that the gateway route resides in.
         */
        var meshName: String?
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: String?
        /**
         * The new gateway route specification to apply. This overwrites the existing data.
         */
        var spec: GatewayRouteSpec?
        /**
         * The name of the virtual gateway that the gateway route is associated with.
         */
        var virtualGatewayName: String?

        fun build(): UpdateGatewayRouteRequest
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.GatewayRouteSpec] inside the given [block]
         */
        fun spec(block: GatewayRouteSpec.DslBuilder.() -> kotlin.Unit) {
            this.spec = GatewayRouteSpec.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var gatewayRouteName: String? = null
        override var meshName: String? = null
        override var meshOwner: String? = null
        override var spec: GatewayRouteSpec? = null
        override var virtualGatewayName: String? = null

        constructor(x: UpdateGatewayRouteRequest) : this() {
            this.clientToken = x.clientToken
            this.gatewayRouteName = x.gatewayRouteName
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.spec = x.spec
            this.virtualGatewayName = x.virtualGatewayName
        }

        override fun build(): UpdateGatewayRouteRequest = UpdateGatewayRouteRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun gatewayRouteName(gatewayRouteName: String): FluentBuilder = apply { this.gatewayRouteName = gatewayRouteName }
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun meshOwner(meshOwner: String): FluentBuilder = apply { this.meshOwner = meshOwner }
        override fun spec(spec: GatewayRouteSpec): FluentBuilder = apply { this.spec = spec }
        override fun virtualGatewayName(virtualGatewayName: String): FluentBuilder = apply { this.virtualGatewayName = virtualGatewayName }
    }
}
