// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 *
 */
class UpdateRouteRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The name of the service mesh that the route resides in.
     */
    val meshName: String? = builder.meshName
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: String? = builder.meshOwner
    /**
     * The name of the route to update.
     */
    val routeName: String? = builder.routeName
    /**
     * The new route specification to apply. This overwrites the existing data.
     */
    val spec: RouteSpec? = builder.spec
    /**
     * The name of the virtual router that the route is associated with.
     */
    val virtualRouterName: String? = builder.virtualRouterName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateRouteRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRouteRequest(")
        append("clientToken=$clientToken,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("routeName=$routeName,")
        append("spec=$spec,")
        append("virtualRouterName=$virtualRouterName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (routeName?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (virtualRouterName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateRouteRequest

        if (clientToken != other.clientToken) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (routeName != other.routeName) return false
        if (spec != other.spec) return false
        if (virtualRouterName != other.virtualRouterName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateRouteRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateRouteRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The name of the service mesh that the route resides in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun meshOwner(meshOwner: String): FluentBuilder
        /**
         * The name of the route to update.
         */
        fun routeName(routeName: String): FluentBuilder
        /**
         * The new route specification to apply. This overwrites the existing data.
         */
        fun spec(spec: RouteSpec): FluentBuilder
        /**
         * The name of the virtual router that the route is associated with.
         */
        fun virtualRouterName(virtualRouterName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        var clientToken: String?
        /**
         * The name of the service mesh that the route resides in.
         */
        var meshName: String?
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: String?
        /**
         * The name of the route to update.
         */
        var routeName: String?
        /**
         * The new route specification to apply. This overwrites the existing data.
         */
        var spec: RouteSpec?
        /**
         * The name of the virtual router that the route is associated with.
         */
        var virtualRouterName: String?

        fun build(): UpdateRouteRequest
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.RouteSpec] inside the given [block]
         */
        fun spec(block: RouteSpec.DslBuilder.() -> kotlin.Unit) {
            this.spec = RouteSpec.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var meshName: String? = null
        override var meshOwner: String? = null
        override var routeName: String? = null
        override var spec: RouteSpec? = null
        override var virtualRouterName: String? = null

        constructor(x: UpdateRouteRequest) : this() {
            this.clientToken = x.clientToken
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.routeName = x.routeName
            this.spec = x.spec
            this.virtualRouterName = x.virtualRouterName
        }

        override fun build(): UpdateRouteRequest = UpdateRouteRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun meshOwner(meshOwner: String): FluentBuilder = apply { this.meshOwner = meshOwner }
        override fun routeName(routeName: String): FluentBuilder = apply { this.routeName = routeName }
        override fun spec(spec: RouteSpec): FluentBuilder = apply { this.spec = spec }
        override fun virtualRouterName(virtualRouterName: String): FluentBuilder = apply { this.virtualRouterName = virtualRouterName }
    }
}
