// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 *
 */
class UpdateVirtualNodeRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The name of the service mesh that the virtual node resides in.
     */
    val meshName: String? = builder.meshName
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: String? = builder.meshOwner
    /**
     * The new virtual node specification to apply. This overwrites the existing data.
     */
    val spec: VirtualNodeSpec? = builder.spec
    /**
     * The name of the virtual node to update.
     */
    val virtualNodeName: String? = builder.virtualNodeName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateVirtualNodeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateVirtualNodeRequest(")
        append("clientToken=$clientToken,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("spec=$spec,")
        append("virtualNodeName=$virtualNodeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (virtualNodeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateVirtualNodeRequest

        if (clientToken != other.clientToken) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (spec != other.spec) return false
        if (virtualNodeName != other.virtualNodeName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateVirtualNodeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateVirtualNodeRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The name of the service mesh that the virtual node resides in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun meshOwner(meshOwner: String): FluentBuilder
        /**
         * The new virtual node specification to apply. This overwrites the existing data.
         */
        fun spec(spec: VirtualNodeSpec): FluentBuilder
        /**
         * The name of the virtual node to update.
         */
        fun virtualNodeName(virtualNodeName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        var clientToken: String?
        /**
         * The name of the service mesh that the virtual node resides in.
         */
        var meshName: String?
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: String?
        /**
         * The new virtual node specification to apply. This overwrites the existing data.
         */
        var spec: VirtualNodeSpec?
        /**
         * The name of the virtual node to update.
         */
        var virtualNodeName: String?

        fun build(): UpdateVirtualNodeRequest
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualNodeSpec] inside the given [block]
         */
        fun spec(block: VirtualNodeSpec.DslBuilder.() -> kotlin.Unit) {
            this.spec = VirtualNodeSpec.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var meshName: String? = null
        override var meshOwner: String? = null
        override var spec: VirtualNodeSpec? = null
        override var virtualNodeName: String? = null

        constructor(x: UpdateVirtualNodeRequest) : this() {
            this.clientToken = x.clientToken
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.spec = x.spec
            this.virtualNodeName = x.virtualNodeName
        }

        override fun build(): UpdateVirtualNodeRequest = UpdateVirtualNodeRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun meshOwner(meshOwner: String): FluentBuilder = apply { this.meshOwner = meshOwner }
        override fun spec(spec: VirtualNodeSpec): FluentBuilder = apply { this.spec = spec }
        override fun virtualNodeName(virtualNodeName: String): FluentBuilder = apply { this.virtualNodeName = virtualNodeName }
    }
}
