// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 *
 */
class UpdateVirtualRouterRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The name of the service mesh that the virtual router resides in.
     */
    val meshName: String? = builder.meshName
    /**
     * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
     */
    val meshOwner: String? = builder.meshOwner
    /**
     * The new virtual router specification to apply. This overwrites the existing data.
     */
    val spec: VirtualRouterSpec? = builder.spec
    /**
     * The name of the virtual router to update.
     */
    val virtualRouterName: String? = builder.virtualRouterName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateVirtualRouterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateVirtualRouterRequest(")
        append("clientToken=$clientToken,")
        append("meshName=$meshName,")
        append("meshOwner=$meshOwner,")
        append("spec=$spec,")
        append("virtualRouterName=$virtualRouterName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (meshName?.hashCode() ?: 0)
        result = 31 * result + (meshOwner?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (virtualRouterName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateVirtualRouterRequest

        if (clientToken != other.clientToken) return false
        if (meshName != other.meshName) return false
        if (meshOwner != other.meshOwner) return false
        if (spec != other.spec) return false
        if (virtualRouterName != other.virtualRouterName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateVirtualRouterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateVirtualRouterRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The name of the service mesh that the virtual router resides in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        fun meshOwner(meshOwner: String): FluentBuilder
        /**
         * The new virtual router specification to apply. This overwrites the existing data.
         */
        fun spec(spec: VirtualRouterSpec): FluentBuilder
        /**
         * The name of the virtual router to update.
         */
        fun virtualRouterName(virtualRouterName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. Up to 36 letters, numbers, hyphens, and underscores are allowed.
         */
        var clientToken: String?
        /**
         * The name of the service mesh that the virtual router resides in.
         */
        var meshName: String?
        /**
         * The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's
         * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes.
         */
        var meshOwner: String?
        /**
         * The new virtual router specification to apply. This overwrites the existing data.
         */
        var spec: VirtualRouterSpec?
        /**
         * The name of the virtual router to update.
         */
        var virtualRouterName: String?

        fun build(): UpdateVirtualRouterRequest
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualRouterSpec] inside the given [block]
         */
        fun spec(block: VirtualRouterSpec.DslBuilder.() -> kotlin.Unit) {
            this.spec = VirtualRouterSpec.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var meshName: String? = null
        override var meshOwner: String? = null
        override var spec: VirtualRouterSpec? = null
        override var virtualRouterName: String? = null

        constructor(x: UpdateVirtualRouterRequest) : this() {
            this.clientToken = x.clientToken
            this.meshName = x.meshName
            this.meshOwner = x.meshOwner
            this.spec = x.spec
            this.virtualRouterName = x.virtualRouterName
        }

        override fun build(): UpdateVirtualRouterRequest = UpdateVirtualRouterRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun meshOwner(meshOwner: String): FluentBuilder = apply { this.meshOwner = meshOwner }
        override fun spec(spec: VirtualRouterSpec): FluentBuilder = apply { this.spec = spec }
        override fun virtualRouterName(virtualRouterName: String): FluentBuilder = apply { this.virtualRouterName = virtualRouterName }
    }
}
