// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a Transport Layer Security (TLS) client policy.
 */
class VirtualGatewayClientPolicyTls private constructor(builder: BuilderImpl) {
    /**
     * A reference to an object that represents a virtual gateway's client's Transport Layer Security (TLS)
     * certificate.
     */
    val certificate: VirtualGatewayClientTlsCertificate? = builder.certificate
    /**
     * Whether the policy is enforced. The default is True, if a value isn't
     * specified.
     */
    val enforce: Boolean? = builder.enforce
    /**
     * One or more ports that the policy is enforced for.
     */
    val ports: Set<Int>? = builder.ports
    /**
     * A reference to an object that represents a Transport Layer Security (TLS) validation context.
     */
    val validation: VirtualGatewayTlsValidationContext? = builder.validation

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VirtualGatewayClientPolicyTls = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualGatewayClientPolicyTls(")
        append("certificate=$certificate,")
        append("enforce=$enforce,")
        append("ports=$ports,")
        append("validation=$validation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.hashCode() ?: 0
        result = 31 * result + (enforce?.hashCode() ?: 0)
        result = 31 * result + (ports?.hashCode() ?: 0)
        result = 31 * result + (validation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VirtualGatewayClientPolicyTls

        if (certificate != other.certificate) return false
        if (enforce != other.enforce) return false
        if (ports != other.ports) return false
        if (validation != other.validation) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VirtualGatewayClientPolicyTls = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VirtualGatewayClientPolicyTls
        /**
         * A reference to an object that represents a virtual gateway's client's Transport Layer Security (TLS)
         * certificate.
         */
        fun certificate(certificate: VirtualGatewayClientTlsCertificate): FluentBuilder
        /**
         * Whether the policy is enforced. The default is True, if a value isn't
         * specified.
         */
        fun enforce(enforce: Boolean): FluentBuilder
        /**
         * One or more ports that the policy is enforced for.
         */
        fun ports(ports: Set<Int>): FluentBuilder
        /**
         * A reference to an object that represents a Transport Layer Security (TLS) validation context.
         */
        fun validation(validation: VirtualGatewayTlsValidationContext): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A reference to an object that represents a virtual gateway's client's Transport Layer Security (TLS)
         * certificate.
         */
        var certificate: VirtualGatewayClientTlsCertificate?
        /**
         * Whether the policy is enforced. The default is True, if a value isn't
         * specified.
         */
        var enforce: Boolean?
        /**
         * One or more ports that the policy is enforced for.
         */
        var ports: Set<Int>?
        /**
         * A reference to an object that represents a Transport Layer Security (TLS) validation context.
         */
        var validation: VirtualGatewayTlsValidationContext?

        fun build(): VirtualGatewayClientPolicyTls
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualGatewayTlsValidationContext] inside the given [block]
         */
        fun validation(block: VirtualGatewayTlsValidationContext.DslBuilder.() -> kotlin.Unit) {
            this.validation = VirtualGatewayTlsValidationContext.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificate: VirtualGatewayClientTlsCertificate? = null
        override var enforce: Boolean? = null
        override var ports: Set<Int>? = null
        override var validation: VirtualGatewayTlsValidationContext? = null

        constructor(x: VirtualGatewayClientPolicyTls) : this() {
            this.certificate = x.certificate
            this.enforce = x.enforce
            this.ports = x.ports
            this.validation = x.validation
        }

        override fun build(): VirtualGatewayClientPolicyTls = VirtualGatewayClientPolicyTls(this)
        override fun certificate(certificate: VirtualGatewayClientTlsCertificate): FluentBuilder = apply { this.certificate = certificate }
        override fun enforce(enforce: Boolean): FluentBuilder = apply { this.enforce = enforce }
        override fun ports(ports: Set<Int>): FluentBuilder = apply { this.ports = ports }
        override fun validation(validation: VirtualGatewayTlsValidationContext): FluentBuilder = apply { this.validation = validation }
    }
}
