// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a virtual gateway returned by a describe operation.
 */
class VirtualGatewayData private constructor(builder: BuilderImpl) {
    /**
     * The name of the service mesh that the virtual gateway resides in.
     */
    val meshName: String? = builder.meshName
    /**
     * An object that represents metadata for a resource.
     */
    val metadata: ResourceMetadata? = builder.metadata
    /**
     * The specifications of the virtual gateway.
     */
    val spec: VirtualGatewaySpec? = builder.spec
    /**
     * The current status of the virtual gateway.
     */
    val status: VirtualGatewayStatus? = builder.status
    /**
     * The name of the virtual gateway.
     */
    val virtualGatewayName: String? = builder.virtualGatewayName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VirtualGatewayData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualGatewayData(")
        append("meshName=$meshName,")
        append("metadata=$metadata,")
        append("spec=$spec,")
        append("status=$status,")
        append("virtualGatewayName=$virtualGatewayName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = meshName?.hashCode() ?: 0
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VirtualGatewayData

        if (meshName != other.meshName) return false
        if (metadata != other.metadata) return false
        if (spec != other.spec) return false
        if (status != other.status) return false
        if (virtualGatewayName != other.virtualGatewayName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VirtualGatewayData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VirtualGatewayData
        /**
         * The name of the service mesh that the virtual gateway resides in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * An object that represents metadata for a resource.
         */
        fun metadata(metadata: ResourceMetadata): FluentBuilder
        /**
         * The specifications of the virtual gateway.
         */
        fun spec(spec: VirtualGatewaySpec): FluentBuilder
        /**
         * The current status of the virtual gateway.
         */
        fun status(status: VirtualGatewayStatus): FluentBuilder
        /**
         * The name of the virtual gateway.
         */
        fun virtualGatewayName(virtualGatewayName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the service mesh that the virtual gateway resides in.
         */
        var meshName: String?
        /**
         * An object that represents metadata for a resource.
         */
        var metadata: ResourceMetadata?
        /**
         * The specifications of the virtual gateway.
         */
        var spec: VirtualGatewaySpec?
        /**
         * The current status of the virtual gateway.
         */
        var status: VirtualGatewayStatus?
        /**
         * The name of the virtual gateway.
         */
        var virtualGatewayName: String?

        fun build(): VirtualGatewayData
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.ResourceMetadata] inside the given [block]
         */
        fun metadata(block: ResourceMetadata.DslBuilder.() -> kotlin.Unit) {
            this.metadata = ResourceMetadata.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualGatewaySpec] inside the given [block]
         */
        fun spec(block: VirtualGatewaySpec.DslBuilder.() -> kotlin.Unit) {
            this.spec = VirtualGatewaySpec.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualGatewayStatus] inside the given [block]
         */
        fun status(block: VirtualGatewayStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = VirtualGatewayStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var meshName: String? = null
        override var metadata: ResourceMetadata? = null
        override var spec: VirtualGatewaySpec? = null
        override var status: VirtualGatewayStatus? = null
        override var virtualGatewayName: String? = null

        constructor(x: VirtualGatewayData) : this() {
            this.meshName = x.meshName
            this.metadata = x.metadata
            this.spec = x.spec
            this.status = x.status
            this.virtualGatewayName = x.virtualGatewayName
        }

        override fun build(): VirtualGatewayData = VirtualGatewayData(this)
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun metadata(metadata: ResourceMetadata): FluentBuilder = apply { this.metadata = metadata }
        override fun spec(spec: VirtualGatewaySpec): FluentBuilder = apply { this.spec = spec }
        override fun status(status: VirtualGatewayStatus): FluentBuilder = apply { this.status = status }
        override fun virtualGatewayName(virtualGatewayName: String): FluentBuilder = apply { this.virtualGatewayName = virtualGatewayName }
    }
}
