// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the Transport Layer Security (TLS) properties for a listener.
 */
class VirtualGatewayListenerTls private constructor(builder: BuilderImpl) {
    /**
     * An object that represents a Transport Layer Security (TLS) certificate.
     */
    val certificate: VirtualGatewayListenerTlsCertificate? = builder.certificate
    /**
     * Specify one of the following modes.
     * <b/>STRICT – Listener only accepts connections with TLS
     * enabled.
     * <b/>PERMISSIVE – Listener accepts connections with or
     * without TLS enabled.
     * <b/>DISABLED – Listener only accepts connections without
     * TLS.
     */
    val mode: VirtualGatewayListenerTlsMode? = builder.mode
    /**
     * A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation
     * context.
     */
    val validation: VirtualGatewayListenerTlsValidationContext? = builder.validation

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VirtualGatewayListenerTls = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualGatewayListenerTls(")
        append("certificate=$certificate,")
        append("mode=$mode,")
        append("validation=$validation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.hashCode() ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (validation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VirtualGatewayListenerTls

        if (certificate != other.certificate) return false
        if (mode != other.mode) return false
        if (validation != other.validation) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VirtualGatewayListenerTls = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VirtualGatewayListenerTls
        /**
         * An object that represents a Transport Layer Security (TLS) certificate.
         */
        fun certificate(certificate: VirtualGatewayListenerTlsCertificate): FluentBuilder
        /**
         * Specify one of the following modes.
         * <b/>STRICT – Listener only accepts connections with TLS
         * enabled.
         * <b/>PERMISSIVE – Listener accepts connections with or
         * without TLS enabled.
         * <b/>DISABLED – Listener only accepts connections without
         * TLS.
         */
        fun mode(mode: VirtualGatewayListenerTlsMode): FluentBuilder
        /**
         * A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation
         * context.
         */
        fun validation(validation: VirtualGatewayListenerTlsValidationContext): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An object that represents a Transport Layer Security (TLS) certificate.
         */
        var certificate: VirtualGatewayListenerTlsCertificate?
        /**
         * Specify one of the following modes.
         * <b/>STRICT – Listener only accepts connections with TLS
         * enabled.
         * <b/>PERMISSIVE – Listener accepts connections with or
         * without TLS enabled.
         * <b/>DISABLED – Listener only accepts connections without
         * TLS.
         */
        var mode: VirtualGatewayListenerTlsMode?
        /**
         * A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation
         * context.
         */
        var validation: VirtualGatewayListenerTlsValidationContext?

        fun build(): VirtualGatewayListenerTls
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualGatewayListenerTlsValidationContext] inside the given [block]
         */
        fun validation(block: VirtualGatewayListenerTlsValidationContext.DslBuilder.() -> kotlin.Unit) {
            this.validation = VirtualGatewayListenerTlsValidationContext.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificate: VirtualGatewayListenerTlsCertificate? = null
        override var mode: VirtualGatewayListenerTlsMode? = null
        override var validation: VirtualGatewayListenerTlsValidationContext? = null

        constructor(x: VirtualGatewayListenerTls) : this() {
            this.certificate = x.certificate
            this.mode = x.mode
            this.validation = x.validation
        }

        override fun build(): VirtualGatewayListenerTls = VirtualGatewayListenerTls(this)
        override fun certificate(certificate: VirtualGatewayListenerTlsCertificate): FluentBuilder = apply { this.certificate = certificate }
        override fun mode(mode: VirtualGatewayListenerTlsMode): FluentBuilder = apply { this.mode = mode }
        override fun validation(validation: VirtualGatewayListenerTlsValidationContext): FluentBuilder = apply { this.validation = validation }
    }
}
