// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a local file certificate.
 * The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS).
 */
class VirtualGatewayListenerTlsFileCertificate private constructor(builder: BuilderImpl) {
    /**
     * The certificate chain for the certificate.
     */
    val certificateChain: String? = builder.certificateChain
    /**
     * The private key for a certificate stored on the file system of the mesh endpoint that
     * the proxy is running on.
     */
    val privateKey: String? = builder.privateKey

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VirtualGatewayListenerTlsFileCertificate = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualGatewayListenerTlsFileCertificate(")
        append("certificateChain=$certificateChain,")
        append("privateKey=$privateKey)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateChain?.hashCode() ?: 0
        result = 31 * result + (privateKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VirtualGatewayListenerTlsFileCertificate

        if (certificateChain != other.certificateChain) return false
        if (privateKey != other.privateKey) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VirtualGatewayListenerTlsFileCertificate = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VirtualGatewayListenerTlsFileCertificate
        /**
         * The certificate chain for the certificate.
         */
        fun certificateChain(certificateChain: String): FluentBuilder
        /**
         * The private key for a certificate stored on the file system of the mesh endpoint that
         * the proxy is running on.
         */
        fun privateKey(privateKey: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The certificate chain for the certificate.
         */
        var certificateChain: String?
        /**
         * The private key for a certificate stored on the file system of the mesh endpoint that
         * the proxy is running on.
         */
        var privateKey: String?

        fun build(): VirtualGatewayListenerTlsFileCertificate
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateChain: String? = null
        override var privateKey: String? = null

        constructor(x: VirtualGatewayListenerTlsFileCertificate) : this() {
            this.certificateChain = x.certificateChain
            this.privateKey = x.privateKey
        }

        override fun build(): VirtualGatewayListenerTlsFileCertificate = VirtualGatewayListenerTlsFileCertificate(this)
        override fun certificateChain(certificateChain: String): FluentBuilder = apply { this.certificateChain = certificateChain }
        override fun privateKey(privateKey: String): FluentBuilder = apply { this.privateKey = privateKey }
    }
}
