// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a Transport Layer Security (TLS) validation context.
 */
class VirtualGatewayTlsValidationContext private constructor(builder: BuilderImpl) {
    /**
     * A reference to an object that represents the SANs for a virtual gateway's listener's
     * Transport Layer Security (TLS) validation context.
     */
    val subjectAlternativeNames: SubjectAlternativeNames? = builder.subjectAlternativeNames
    /**
     * A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
     * certificate.
     */
    val trust: VirtualGatewayTlsValidationContextTrust? = builder.trust

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VirtualGatewayTlsValidationContext = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualGatewayTlsValidationContext(")
        append("subjectAlternativeNames=$subjectAlternativeNames,")
        append("trust=$trust)")
    }

    override fun hashCode(): kotlin.Int {
        var result = subjectAlternativeNames?.hashCode() ?: 0
        result = 31 * result + (trust?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VirtualGatewayTlsValidationContext

        if (subjectAlternativeNames != other.subjectAlternativeNames) return false
        if (trust != other.trust) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VirtualGatewayTlsValidationContext = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VirtualGatewayTlsValidationContext
        /**
         * A reference to an object that represents the SANs for a virtual gateway's listener's
         * Transport Layer Security (TLS) validation context.
         */
        fun subjectAlternativeNames(subjectAlternativeNames: SubjectAlternativeNames): FluentBuilder
        /**
         * A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
         * certificate.
         */
        fun trust(trust: VirtualGatewayTlsValidationContextTrust): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A reference to an object that represents the SANs for a virtual gateway's listener's
         * Transport Layer Security (TLS) validation context.
         */
        var subjectAlternativeNames: SubjectAlternativeNames?
        /**
         * A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS)
         * certificate.
         */
        var trust: VirtualGatewayTlsValidationContextTrust?

        fun build(): VirtualGatewayTlsValidationContext
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.SubjectAlternativeNames] inside the given [block]
         */
        fun subjectAlternativeNames(block: SubjectAlternativeNames.DslBuilder.() -> kotlin.Unit) {
            this.subjectAlternativeNames = SubjectAlternativeNames.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var subjectAlternativeNames: SubjectAlternativeNames? = null
        override var trust: VirtualGatewayTlsValidationContextTrust? = null

        constructor(x: VirtualGatewayTlsValidationContext) : this() {
            this.subjectAlternativeNames = x.subjectAlternativeNames
            this.trust = x.trust
        }

        override fun build(): VirtualGatewayTlsValidationContext = VirtualGatewayTlsValidationContext(this)
        override fun subjectAlternativeNames(subjectAlternativeNames: SubjectAlternativeNames): FluentBuilder = apply { this.subjectAlternativeNames = subjectAlternativeNames }
        override fun trust(trust: VirtualGatewayTlsValidationContextTrust): FluentBuilder = apply { this.trust = trust }
    }
}
