// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a virtual node returned by a describe operation.
 */
class VirtualNodeData private constructor(builder: BuilderImpl) {
    /**
     * The name of the service mesh that the virtual node resides in.
     */
    val meshName: String? = builder.meshName
    /**
     * The associated metadata for the virtual node.
     */
    val metadata: ResourceMetadata? = builder.metadata
    /**
     * The specifications of the virtual node.
     */
    val spec: VirtualNodeSpec? = builder.spec
    /**
     * The current status for the virtual node.
     */
    val status: VirtualNodeStatus? = builder.status
    /**
     * The name of the virtual node.
     */
    val virtualNodeName: String? = builder.virtualNodeName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VirtualNodeData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualNodeData(")
        append("meshName=$meshName,")
        append("metadata=$metadata,")
        append("spec=$spec,")
        append("status=$status,")
        append("virtualNodeName=$virtualNodeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = meshName?.hashCode() ?: 0
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (virtualNodeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VirtualNodeData

        if (meshName != other.meshName) return false
        if (metadata != other.metadata) return false
        if (spec != other.spec) return false
        if (status != other.status) return false
        if (virtualNodeName != other.virtualNodeName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VirtualNodeData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VirtualNodeData
        /**
         * The name of the service mesh that the virtual node resides in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The associated metadata for the virtual node.
         */
        fun metadata(metadata: ResourceMetadata): FluentBuilder
        /**
         * The specifications of the virtual node.
         */
        fun spec(spec: VirtualNodeSpec): FluentBuilder
        /**
         * The current status for the virtual node.
         */
        fun status(status: VirtualNodeStatus): FluentBuilder
        /**
         * The name of the virtual node.
         */
        fun virtualNodeName(virtualNodeName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the service mesh that the virtual node resides in.
         */
        var meshName: String?
        /**
         * The associated metadata for the virtual node.
         */
        var metadata: ResourceMetadata?
        /**
         * The specifications of the virtual node.
         */
        var spec: VirtualNodeSpec?
        /**
         * The current status for the virtual node.
         */
        var status: VirtualNodeStatus?
        /**
         * The name of the virtual node.
         */
        var virtualNodeName: String?

        fun build(): VirtualNodeData
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.ResourceMetadata] inside the given [block]
         */
        fun metadata(block: ResourceMetadata.DslBuilder.() -> kotlin.Unit) {
            this.metadata = ResourceMetadata.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualNodeSpec] inside the given [block]
         */
        fun spec(block: VirtualNodeSpec.DslBuilder.() -> kotlin.Unit) {
            this.spec = VirtualNodeSpec.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualNodeStatus] inside the given [block]
         */
        fun status(block: VirtualNodeStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = VirtualNodeStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var meshName: String? = null
        override var metadata: ResourceMetadata? = null
        override var spec: VirtualNodeSpec? = null
        override var status: VirtualNodeStatus? = null
        override var virtualNodeName: String? = null

        constructor(x: VirtualNodeData) : this() {
            this.meshName = x.meshName
            this.metadata = x.metadata
            this.spec = x.spec
            this.status = x.status
            this.virtualNodeName = x.virtualNodeName
        }

        override fun build(): VirtualNodeData = VirtualNodeData(this)
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun metadata(metadata: ResourceMetadata): FluentBuilder = apply { this.metadata = metadata }
        override fun spec(spec: VirtualNodeSpec): FluentBuilder = apply { this.spec = spec }
        override fun status(status: VirtualNodeStatus): FluentBuilder = apply { this.status = status }
        override fun virtualNodeName(virtualNodeName: String): FluentBuilder = apply { this.virtualNodeName = virtualNodeName }
    }
}
