// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents the specification of a virtual node.
 */
class VirtualNodeSpec private constructor(builder: BuilderImpl) {
    /**
     * A reference to an object that represents the defaults for backends.
     */
    val backendDefaults: BackendDefaults? = builder.backendDefaults
    /**
     * The backends that the virtual node is expected to send outbound traffic to.
     */
    val backends: List<Backend>? = builder.backends
    /**
     * The listener that the virtual node is expected to receive inbound traffic from. You can
     * specify one listener.
     */
    val listeners: List<Listener>? = builder.listeners
    /**
     * The inbound and outbound access logging information for the virtual node.
     */
    val logging: Logging? = builder.logging
    /**
     * The service discovery information for the virtual node. If your virtual node does not
     * expect ingress traffic, you can omit this parameter. If you specify a
     * listener, then you must specify service discovery information.
     */
    val serviceDiscovery: ServiceDiscovery? = builder.serviceDiscovery

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VirtualNodeSpec = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualNodeSpec(")
        append("backendDefaults=$backendDefaults,")
        append("backends=$backends,")
        append("listeners=$listeners,")
        append("logging=$logging,")
        append("serviceDiscovery=$serviceDiscovery)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backendDefaults?.hashCode() ?: 0
        result = 31 * result + (backends?.hashCode() ?: 0)
        result = 31 * result + (listeners?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (serviceDiscovery?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VirtualNodeSpec

        if (backendDefaults != other.backendDefaults) return false
        if (backends != other.backends) return false
        if (listeners != other.listeners) return false
        if (logging != other.logging) return false
        if (serviceDiscovery != other.serviceDiscovery) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VirtualNodeSpec = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VirtualNodeSpec
        /**
         * A reference to an object that represents the defaults for backends.
         */
        fun backendDefaults(backendDefaults: BackendDefaults): FluentBuilder
        /**
         * The backends that the virtual node is expected to send outbound traffic to.
         */
        fun backends(backends: List<Backend>): FluentBuilder
        /**
         * The listener that the virtual node is expected to receive inbound traffic from. You can
         * specify one listener.
         */
        fun listeners(listeners: List<Listener>): FluentBuilder
        /**
         * The inbound and outbound access logging information for the virtual node.
         */
        fun logging(logging: Logging): FluentBuilder
        /**
         * The service discovery information for the virtual node. If your virtual node does not
         * expect ingress traffic, you can omit this parameter. If you specify a
         * listener, then you must specify service discovery information.
         */
        fun serviceDiscovery(serviceDiscovery: ServiceDiscovery): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A reference to an object that represents the defaults for backends.
         */
        var backendDefaults: BackendDefaults?
        /**
         * The backends that the virtual node is expected to send outbound traffic to.
         */
        var backends: List<Backend>?
        /**
         * The listener that the virtual node is expected to receive inbound traffic from. You can
         * specify one listener.
         */
        var listeners: List<Listener>?
        /**
         * The inbound and outbound access logging information for the virtual node.
         */
        var logging: Logging?
        /**
         * The service discovery information for the virtual node. If your virtual node does not
         * expect ingress traffic, you can omit this parameter. If you specify a
         * listener, then you must specify service discovery information.
         */
        var serviceDiscovery: ServiceDiscovery?

        fun build(): VirtualNodeSpec
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.BackendDefaults] inside the given [block]
         */
        fun backendDefaults(block: BackendDefaults.DslBuilder.() -> kotlin.Unit) {
            this.backendDefaults = BackendDefaults.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.Logging] inside the given [block]
         */
        fun logging(block: Logging.DslBuilder.() -> kotlin.Unit) {
            this.logging = Logging.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var backendDefaults: BackendDefaults? = null
        override var backends: List<Backend>? = null
        override var listeners: List<Listener>? = null
        override var logging: Logging? = null
        override var serviceDiscovery: ServiceDiscovery? = null

        constructor(x: VirtualNodeSpec) : this() {
            this.backendDefaults = x.backendDefaults
            this.backends = x.backends
            this.listeners = x.listeners
            this.logging = x.logging
            this.serviceDiscovery = x.serviceDiscovery
        }

        override fun build(): VirtualNodeSpec = VirtualNodeSpec(this)
        override fun backendDefaults(backendDefaults: BackendDefaults): FluentBuilder = apply { this.backendDefaults = backendDefaults }
        override fun backends(backends: List<Backend>): FluentBuilder = apply { this.backends = backends }
        override fun listeners(listeners: List<Listener>): FluentBuilder = apply { this.listeners = listeners }
        override fun logging(logging: Logging): FluentBuilder = apply { this.logging = logging }
        override fun serviceDiscovery(serviceDiscovery: ServiceDiscovery): FluentBuilder = apply { this.serviceDiscovery = serviceDiscovery }
    }
}
