// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a virtual router returned by a describe operation.
 */
class VirtualRouterData private constructor(builder: BuilderImpl) {
    /**
     * The name of the service mesh that the virtual router resides in.
     */
    val meshName: String? = builder.meshName
    /**
     * The associated metadata for the virtual router.
     */
    val metadata: ResourceMetadata? = builder.metadata
    /**
     * The specifications of the virtual router.
     */
    val spec: VirtualRouterSpec? = builder.spec
    /**
     * The current status of the virtual router.
     */
    val status: VirtualRouterStatus? = builder.status
    /**
     * The name of the virtual router.
     */
    val virtualRouterName: String? = builder.virtualRouterName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VirtualRouterData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualRouterData(")
        append("meshName=$meshName,")
        append("metadata=$metadata,")
        append("spec=$spec,")
        append("status=$status,")
        append("virtualRouterName=$virtualRouterName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = meshName?.hashCode() ?: 0
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (virtualRouterName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VirtualRouterData

        if (meshName != other.meshName) return false
        if (metadata != other.metadata) return false
        if (spec != other.spec) return false
        if (status != other.status) return false
        if (virtualRouterName != other.virtualRouterName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VirtualRouterData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VirtualRouterData
        /**
         * The name of the service mesh that the virtual router resides in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * The associated metadata for the virtual router.
         */
        fun metadata(metadata: ResourceMetadata): FluentBuilder
        /**
         * The specifications of the virtual router.
         */
        fun spec(spec: VirtualRouterSpec): FluentBuilder
        /**
         * The current status of the virtual router.
         */
        fun status(status: VirtualRouterStatus): FluentBuilder
        /**
         * The name of the virtual router.
         */
        fun virtualRouterName(virtualRouterName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the service mesh that the virtual router resides in.
         */
        var meshName: String?
        /**
         * The associated metadata for the virtual router.
         */
        var metadata: ResourceMetadata?
        /**
         * The specifications of the virtual router.
         */
        var spec: VirtualRouterSpec?
        /**
         * The current status of the virtual router.
         */
        var status: VirtualRouterStatus?
        /**
         * The name of the virtual router.
         */
        var virtualRouterName: String?

        fun build(): VirtualRouterData
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.ResourceMetadata] inside the given [block]
         */
        fun metadata(block: ResourceMetadata.DslBuilder.() -> kotlin.Unit) {
            this.metadata = ResourceMetadata.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualRouterSpec] inside the given [block]
         */
        fun spec(block: VirtualRouterSpec.DslBuilder.() -> kotlin.Unit) {
            this.spec = VirtualRouterSpec.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualRouterStatus] inside the given [block]
         */
        fun status(block: VirtualRouterStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = VirtualRouterStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var meshName: String? = null
        override var metadata: ResourceMetadata? = null
        override var spec: VirtualRouterSpec? = null
        override var status: VirtualRouterStatus? = null
        override var virtualRouterName: String? = null

        constructor(x: VirtualRouterData) : this() {
            this.meshName = x.meshName
            this.metadata = x.metadata
            this.spec = x.spec
            this.status = x.status
            this.virtualRouterName = x.virtualRouterName
        }

        override fun build(): VirtualRouterData = VirtualRouterData(this)
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun metadata(metadata: ResourceMetadata): FluentBuilder = apply { this.metadata = metadata }
        override fun spec(spec: VirtualRouterSpec): FluentBuilder = apply { this.spec = spec }
        override fun status(status: VirtualRouterStatus): FluentBuilder = apply { this.status = status }
        override fun virtualRouterName(virtualRouterName: String): FluentBuilder = apply { this.virtualRouterName = virtualRouterName }
    }
}
