// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a virtual service returned by a describe operation.
 */
class VirtualServiceData private constructor(builder: BuilderImpl) {
    /**
     * The name of the service mesh that the virtual service resides in.
     */
    val meshName: String? = builder.meshName
    /**
     * An object that represents metadata for a resource.
     */
    val metadata: ResourceMetadata? = builder.metadata
    /**
     * The specifications of the virtual service.
     */
    val spec: VirtualServiceSpec? = builder.spec
    /**
     * The current status of the virtual service.
     */
    val status: VirtualServiceStatus? = builder.status
    /**
     * The name of the virtual service.
     */
    val virtualServiceName: String? = builder.virtualServiceName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VirtualServiceData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualServiceData(")
        append("meshName=$meshName,")
        append("metadata=$metadata,")
        append("spec=$spec,")
        append("status=$status,")
        append("virtualServiceName=$virtualServiceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = meshName?.hashCode() ?: 0
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (virtualServiceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VirtualServiceData

        if (meshName != other.meshName) return false
        if (metadata != other.metadata) return false
        if (spec != other.spec) return false
        if (status != other.status) return false
        if (virtualServiceName != other.virtualServiceName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VirtualServiceData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VirtualServiceData
        /**
         * The name of the service mesh that the virtual service resides in.
         */
        fun meshName(meshName: String): FluentBuilder
        /**
         * An object that represents metadata for a resource.
         */
        fun metadata(metadata: ResourceMetadata): FluentBuilder
        /**
         * The specifications of the virtual service.
         */
        fun spec(spec: VirtualServiceSpec): FluentBuilder
        /**
         * The current status of the virtual service.
         */
        fun status(status: VirtualServiceStatus): FluentBuilder
        /**
         * The name of the virtual service.
         */
        fun virtualServiceName(virtualServiceName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the service mesh that the virtual service resides in.
         */
        var meshName: String?
        /**
         * An object that represents metadata for a resource.
         */
        var metadata: ResourceMetadata?
        /**
         * The specifications of the virtual service.
         */
        var spec: VirtualServiceSpec?
        /**
         * The current status of the virtual service.
         */
        var status: VirtualServiceStatus?
        /**
         * The name of the virtual service.
         */
        var virtualServiceName: String?

        fun build(): VirtualServiceData
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.ResourceMetadata] inside the given [block]
         */
        fun metadata(block: ResourceMetadata.DslBuilder.() -> kotlin.Unit) {
            this.metadata = ResourceMetadata.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualServiceSpec] inside the given [block]
         */
        fun spec(block: VirtualServiceSpec.DslBuilder.() -> kotlin.Unit) {
            this.spec = VirtualServiceSpec.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appmesh.model.VirtualServiceStatus] inside the given [block]
         */
        fun status(block: VirtualServiceStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = VirtualServiceStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var meshName: String? = null
        override var metadata: ResourceMetadata? = null
        override var spec: VirtualServiceSpec? = null
        override var status: VirtualServiceStatus? = null
        override var virtualServiceName: String? = null

        constructor(x: VirtualServiceData) : this() {
            this.meshName = x.meshName
            this.metadata = x.metadata
            this.spec = x.spec
            this.status = x.status
            this.virtualServiceName = x.virtualServiceName
        }

        override fun build(): VirtualServiceData = VirtualServiceData(this)
        override fun meshName(meshName: String): FluentBuilder = apply { this.meshName = meshName }
        override fun metadata(metadata: ResourceMetadata): FluentBuilder = apply { this.metadata = metadata }
        override fun spec(spec: VirtualServiceSpec): FluentBuilder = apply { this.spec = spec }
        override fun status(status: VirtualServiceStatus): FluentBuilder = apply { this.status = status }
        override fun virtualServiceName(virtualServiceName: String): FluentBuilder = apply { this.virtualServiceName = virtualServiceName }
    }
}
