// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appmesh.model



/**
 * An object that represents a target and its relative weight. Traffic is distributed
 * across targets according to their relative weight. For example, a weighted target with a
 * relative weight of 50 receives five times as much traffic as one with a relative weight of
 * 10. The total weight for all targets combined must be less than or equal to 100.
 */
class WeightedTarget private constructor(builder: BuilderImpl) {
    /**
     * The virtual node to associate with the weighted target.
     */
    val virtualNode: String? = builder.virtualNode
    /**
     * The relative weight of the weighted target.
     */
    val weight: Int = builder.weight

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): WeightedTarget = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("WeightedTarget(")
        append("virtualNode=$virtualNode,")
        append("weight=$weight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = virtualNode?.hashCode() ?: 0
        result = 31 * result + (weight)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as WeightedTarget

        if (virtualNode != other.virtualNode) return false
        if (weight != other.weight) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): WeightedTarget = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): WeightedTarget
        /**
         * The virtual node to associate with the weighted target.
         */
        fun virtualNode(virtualNode: String): FluentBuilder
        /**
         * The relative weight of the weighted target.
         */
        fun weight(weight: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The virtual node to associate with the weighted target.
         */
        var virtualNode: String?
        /**
         * The relative weight of the weighted target.
         */
        var weight: Int

        fun build(): WeightedTarget
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var virtualNode: String? = null
        override var weight: Int = 0

        constructor(x: WeightedTarget) : this() {
            this.virtualNode = x.virtualNode
            this.weight = x.weight
        }

        override fun build(): WeightedTarget = WeightedTarget(this)
        override fun virtualNode(virtualNode: String): FluentBuilder = apply { this.virtualNode = virtualNode }
        override fun weight(weight: Int): FluentBuilder = apply { this.weight = weight }
    }
}
