// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.appstream.model.*
import aws.sdk.kotlin.services.appstream.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "AppStream"
const val ServiceApiVersion: String = "2016-12-01"
const val SdkVersion: String = "0.16.4-beta"

internal class DefaultAppStreamClient(override val config: AppStreamClient.Config) : AppStreamClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates the specified application with the specified fleet. This is only supported for Elastic fleets.
     */
    override suspend fun associateApplicationFleet(input: AssociateApplicationFleetRequest): AssociateApplicationFleetResponse {
        val op = SdkHttpOperation.build<AssociateApplicationFleetRequest, AssociateApplicationFleetResponse> {
            serializer = AssociateApplicationFleetOperationSerializer()
            deserializer = AssociateApplicationFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateApplicationFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates an application to entitle.
     */
    override suspend fun associateApplicationToEntitlement(input: AssociateApplicationToEntitlementRequest): AssociateApplicationToEntitlementResponse {
        val op = SdkHttpOperation.build<AssociateApplicationToEntitlementRequest, AssociateApplicationToEntitlementResponse> {
            serializer = AssociateApplicationToEntitlementOperationSerializer()
            deserializer = AssociateApplicationToEntitlementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateApplicationToEntitlement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified fleet with the specified stack.
     */
    override suspend fun associateFleet(input: AssociateFleetRequest): AssociateFleetResponse {
        val op = SdkHttpOperation.build<AssociateFleetRequest, AssociateFleetResponse> {
            serializer = AssociateFleetOperationSerializer()
            deserializer = AssociateFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified users with the specified stacks. Users in a user pool cannot be assigned to stacks with fleets that are joined to an Active Directory domain.
     */
    override suspend fun batchAssociateUserStack(input: BatchAssociateUserStackRequest): BatchAssociateUserStackResponse {
        val op = SdkHttpOperation.build<BatchAssociateUserStackRequest, BatchAssociateUserStackResponse> {
            serializer = BatchAssociateUserStackOperationSerializer()
            deserializer = BatchAssociateUserStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchAssociateUserStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified users from the specified stacks.
     */
    override suspend fun batchDisassociateUserStack(input: BatchDisassociateUserStackRequest): BatchDisassociateUserStackResponse {
        val op = SdkHttpOperation.build<BatchDisassociateUserStackRequest, BatchDisassociateUserStackResponse> {
            serializer = BatchDisassociateUserStackOperationSerializer()
            deserializer = BatchDisassociateUserStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDisassociateUserStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Copies the image within the same region or to a new region within the same AWS account. Note that any tags you added to the image will not be copied.
     */
    override suspend fun copyImage(input: CopyImageRequest): CopyImageResponse {
        val op = SdkHttpOperation.build<CopyImageRequest, CopyImageResponse> {
            serializer = CopyImageOperationSerializer()
            deserializer = CopyImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopyImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an app block.
     *
     * App blocks are an Amazon AppStream 2.0 resource that stores the details about the virtual hard disk in an S3 bucket. It also stores the setup script with details about how to mount the virtual hard disk. The virtual hard disk includes the application binaries and other files necessary to launch your applications. Multiple applications can be assigned to a single app block.
     *
     * This is only supported for Elastic fleets.
     */
    override suspend fun createAppBlock(input: CreateAppBlockRequest): CreateAppBlockResponse {
        val op = SdkHttpOperation.build<CreateAppBlockRequest, CreateAppBlockResponse> {
            serializer = CreateAppBlockOperationSerializer()
            deserializer = CreateAppBlockOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAppBlock"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an application.
     *
     * Applications are an Amazon AppStream 2.0 resource that stores the details about how to launch applications on Elastic fleet streaming instances. An application consists of the launch details, icon, and display name. Applications are associated with an app block that contains the application binaries and other files. The applications assigned to an Elastic fleet are the applications users can launch.
     *
     * This is only supported for Elastic fleets.
     */
    override suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse {
        val op = SdkHttpOperation.build<CreateApplicationRequest, CreateApplicationResponse> {
            serializer = CreateApplicationOperationSerializer()
            deserializer = CreateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
     */
    override suspend fun createDirectoryConfig(input: CreateDirectoryConfigRequest): CreateDirectoryConfigResponse {
        val op = SdkHttpOperation.build<CreateDirectoryConfigRequest, CreateDirectoryConfigResponse> {
            serializer = CreateDirectoryConfigOperationSerializer()
            deserializer = CreateDirectoryConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDirectoryConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new entitlement. Entitlements control access to specific applications within a stack, based on user attributes. Entitlements apply to SAML 2.0 federated user identities. Amazon AppStream 2.0 user pool and streaming URL users are entitled to all applications in a stack. Entitlements don't apply to the desktop stream view application, or to applications managed by a dynamic app provider using the Dynamic Application Framework.
     */
    override suspend fun createEntitlement(input: CreateEntitlementRequest): CreateEntitlementResponse {
        val op = SdkHttpOperation.build<CreateEntitlementRequest, CreateEntitlementResponse> {
            serializer = CreateEntitlementOperationSerializer()
            deserializer = CreateEntitlementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEntitlement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a fleet. A fleet consists of streaming instances that run a specified image when using Always-On or On-Demand.
     */
    override suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse {
        val op = SdkHttpOperation.build<CreateFleetRequest, CreateFleetResponse> {
            serializer = CreateFleetOperationSerializer()
            deserializer = CreateFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an image builder. An image builder is a virtual machine that is used to create an image.
     *
     * The initial state of the builder is `PENDING`. When it is ready, the state is `RUNNING`.
     */
    override suspend fun createImageBuilder(input: CreateImageBuilderRequest): CreateImageBuilderResponse {
        val op = SdkHttpOperation.build<CreateImageBuilderRequest, CreateImageBuilderResponse> {
            serializer = CreateImageBuilderOperationSerializer()
            deserializer = CreateImageBuilderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateImageBuilder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a URL to start an image builder streaming session.
     */
    override suspend fun createImageBuilderStreamingUrl(input: CreateImageBuilderStreamingUrlRequest): CreateImageBuilderStreamingUrlResponse {
        val op = SdkHttpOperation.build<CreateImageBuilderStreamingUrlRequest, CreateImageBuilderStreamingUrlResponse> {
            serializer = CreateImageBuilderStreamingURLOperationSerializer()
            deserializer = CreateImageBuilderStreamingURLOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateImageBuilderStreamingURL"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access policies, and storage configurations.
     */
    override suspend fun createStack(input: CreateStackRequest): CreateStackResponse {
        val op = SdkHttpOperation.build<CreateStackRequest, CreateStackResponse> {
            serializer = CreateStackOperationSerializer()
            deserializer = CreateStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL enables application streaming to be tested without user setup.
     */
    override suspend fun createStreamingUrl(input: CreateStreamingUrlRequest): CreateStreamingUrlResponse {
        val op = SdkHttpOperation.build<CreateStreamingUrlRequest, CreateStreamingUrlResponse> {
            serializer = CreateStreamingURLOperationSerializer()
            deserializer = CreateStreamingURLOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStreamingURL"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent software.
     *
     * For more information, see the "Update an Image by Using Managed AppStream 2.0 Image Updates" section in [Administer Your AppStream 2.0 Images](https://docs.aws.amazon.com/appstream2/latest/developerguide/administer-images.html), in the *Amazon AppStream 2.0 Administration Guide*.
     */
    override suspend fun createUpdatedImage(input: CreateUpdatedImageRequest): CreateUpdatedImageResponse {
        val op = SdkHttpOperation.build<CreateUpdatedImageRequest, CreateUpdatedImageResponse> {
            serializer = CreateUpdatedImageOperationSerializer()
            deserializer = CreateUpdatedImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUpdatedImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a usage report subscription. Usage reports are generated daily.
     */
    override suspend fun createUsageReportSubscription(input: CreateUsageReportSubscriptionRequest): CreateUsageReportSubscriptionResponse {
        val op = SdkHttpOperation.build<CreateUsageReportSubscriptionRequest, CreateUsageReportSubscriptionResponse> {
            serializer = CreateUsageReportSubscriptionOperationSerializer()
            deserializer = CreateUsageReportSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUsageReportSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new user in the user pool.
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an app block.
     */
    override suspend fun deleteAppBlock(input: DeleteAppBlockRequest): DeleteAppBlockResponse {
        val op = SdkHttpOperation.build<DeleteAppBlockRequest, DeleteAppBlockResponse> {
            serializer = DeleteAppBlockOperationSerializer()
            deserializer = DeleteAppBlockOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAppBlock"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an application.
     */
    override suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse {
        val op = SdkHttpOperation.build<DeleteApplicationRequest, DeleteApplicationResponse> {
            serializer = DeleteApplicationOperationSerializer()
            deserializer = DeleteApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Directory Config object from AppStream 2.0. This object includes the information required to join streaming instances to an Active Directory domain.
     */
    override suspend fun deleteDirectoryConfig(input: DeleteDirectoryConfigRequest): DeleteDirectoryConfigResponse {
        val op = SdkHttpOperation.build<DeleteDirectoryConfigRequest, DeleteDirectoryConfigResponse> {
            serializer = DeleteDirectoryConfigOperationSerializer()
            deserializer = DeleteDirectoryConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDirectoryConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified entitlement.
     */
    override suspend fun deleteEntitlement(input: DeleteEntitlementRequest): DeleteEntitlementResponse {
        val op = SdkHttpOperation.build<DeleteEntitlementRequest, DeleteEntitlementResponse> {
            serializer = DeleteEntitlementOperationSerializer()
            deserializer = DeleteEntitlementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEntitlement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified fleet.
     */
    override suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse {
        val op = SdkHttpOperation.build<DeleteFleetRequest, DeleteFleetResponse> {
            serializer = DeleteFleetOperationSerializer()
            deserializer = DeleteFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified image. You cannot delete an image when it is in use. After you delete an image, you cannot provision new capacity using the image.
     */
    override suspend fun deleteImage(input: DeleteImageRequest): DeleteImageResponse {
        val op = SdkHttpOperation.build<DeleteImageRequest, DeleteImageResponse> {
            serializer = DeleteImageOperationSerializer()
            deserializer = DeleteImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified image builder and releases the capacity.
     */
    override suspend fun deleteImageBuilder(input: DeleteImageBuilderRequest): DeleteImageBuilderResponse {
        val op = SdkHttpOperation.build<DeleteImageBuilderRequest, DeleteImageBuilderResponse> {
            serializer = DeleteImageBuilderOperationSerializer()
            deserializer = DeleteImageBuilderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteImageBuilder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes permissions for the specified private image. After you delete permissions for an image, AWS accounts to which you previously granted these permissions can no longer use the image.
     */
    override suspend fun deleteImagePermissions(input: DeleteImagePermissionsRequest): DeleteImagePermissionsResponse {
        val op = SdkHttpOperation.build<DeleteImagePermissionsRequest, DeleteImagePermissionsResponse> {
            serializer = DeleteImagePermissionsOperationSerializer()
            deserializer = DeleteImagePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteImagePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified stack. After the stack is deleted, the application streaming environment provided by the stack is no longer available to users. Also, any reservations made for application streaming sessions for the stack are released.
     */
    override suspend fun deleteStack(input: DeleteStackRequest): DeleteStackResponse {
        val op = SdkHttpOperation.build<DeleteStackRequest, DeleteStackResponse> {
            serializer = DeleteStackOperationSerializer()
            deserializer = DeleteStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables usage report generation.
     */
    override suspend fun deleteUsageReportSubscription(input: DeleteUsageReportSubscriptionRequest): DeleteUsageReportSubscriptionResponse {
        val op = SdkHttpOperation.build<DeleteUsageReportSubscriptionRequest, DeleteUsageReportSubscriptionResponse> {
            serializer = DeleteUsageReportSubscriptionOperationSerializer()
            deserializer = DeleteUsageReportSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUsageReportSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a user from the user pool.
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more app blocks.
     */
    override suspend fun describeAppBlocks(input: DescribeAppBlocksRequest): DescribeAppBlocksResponse {
        val op = SdkHttpOperation.build<DescribeAppBlocksRequest, DescribeAppBlocksResponse> {
            serializer = DescribeAppBlocksOperationSerializer()
            deserializer = DescribeAppBlocksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppBlocks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more application fleet associations. Either ApplicationArn or FleetName must be specified.
     */
    override suspend fun describeApplicationFleetAssociations(input: DescribeApplicationFleetAssociationsRequest): DescribeApplicationFleetAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeApplicationFleetAssociationsRequest, DescribeApplicationFleetAssociationsResponse> {
            serializer = DescribeApplicationFleetAssociationsOperationSerializer()
            deserializer = DescribeApplicationFleetAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApplicationFleetAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more applications.
     */
    override suspend fun describeApplications(input: DescribeApplicationsRequest): DescribeApplicationsResponse {
        val op = SdkHttpOperation.build<DescribeApplicationsRequest, DescribeApplicationsResponse> {
            serializer = DescribeApplicationsOperationSerializer()
            deserializer = DescribeApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApplications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names for these objects are provided. Otherwise, all Directory Config objects in the account are described. These objects include the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
     *
     * Although the response syntax in this topic includes the account password, this password is not returned in the actual response.
     */
    override suspend fun describeDirectoryConfigs(input: DescribeDirectoryConfigsRequest): DescribeDirectoryConfigsResponse {
        val op = SdkHttpOperation.build<DescribeDirectoryConfigsRequest, DescribeDirectoryConfigsResponse> {
            serializer = DescribeDirectoryConfigsOperationSerializer()
            deserializer = DescribeDirectoryConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDirectoryConfigs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one of more entitlements.
     */
    override suspend fun describeEntitlements(input: DescribeEntitlementsRequest): DescribeEntitlementsResponse {
        val op = SdkHttpOperation.build<DescribeEntitlementsRequest, DescribeEntitlementsResponse> {
            serializer = DescribeEntitlementsOperationSerializer()
            deserializer = DescribeEntitlementsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEntitlements"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all fleets in the account are described.
     */
    override suspend fun describeFleets(input: DescribeFleetsRequest): DescribeFleetsResponse {
        val op = SdkHttpOperation.build<DescribeFleetsRequest, DescribeFleetsResponse> {
            serializer = DescribeFleetsOperationSerializer()
            deserializer = DescribeFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFleets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more specified image builders, if the image builder names are provided. Otherwise, all image builders in the account are described.
     */
    override suspend fun describeImageBuilders(input: DescribeImageBuildersRequest): DescribeImageBuildersResponse {
        val op = SdkHttpOperation.build<DescribeImageBuildersRequest, DescribeImageBuildersResponse> {
            serializer = DescribeImageBuildersOperationSerializer()
            deserializer = DescribeImageBuildersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeImageBuilders"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own.
     */
    override suspend fun describeImagePermissions(input: DescribeImagePermissionsRequest): DescribeImagePermissionsResponse {
        val op = SdkHttpOperation.build<DescribeImagePermissionsRequest, DescribeImagePermissionsResponse> {
            serializer = DescribeImagePermissionsOperationSerializer()
            deserializer = DescribeImagePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeImagePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided. Otherwise, all images in the account are described.
     */
    override suspend fun describeImages(input: DescribeImagesRequest): DescribeImagesResponse {
        val op = SdkHttpOperation.build<DescribeImagesRequest, DescribeImagesResponse> {
            serializer = DescribeImagesOperationSerializer()
            deserializer = DescribeImagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeImages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided for the stack and fleet, only streaming sessions for that user are described. If an authentication type is not provided, the default is to authenticate users using a streaming URL.
     */
    override suspend fun describeSessions(input: DescribeSessionsRequest): DescribeSessionsResponse {
        val op = SdkHttpOperation.build<DescribeSessionsRequest, DescribeSessionsResponse> {
            serializer = DescribeSessionsOperationSerializer()
            deserializer = DescribeSessionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSessions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all stacks in the account are described.
     */
    override suspend fun describeStacks(input: DescribeStacksRequest): DescribeStacksResponse {
        val op = SdkHttpOperation.build<DescribeStacksRequest, DescribeStacksResponse> {
            serializer = DescribeStacksOperationSerializer()
            deserializer = DescribeStacksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStacks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more usage report subscriptions.
     */
    override suspend fun describeUsageReportSubscriptions(input: DescribeUsageReportSubscriptionsRequest): DescribeUsageReportSubscriptionsResponse {
        val op = SdkHttpOperation.build<DescribeUsageReportSubscriptionsRequest, DescribeUsageReportSubscriptionsResponse> {
            serializer = DescribeUsageReportSubscriptionsOperationSerializer()
            deserializer = DescribeUsageReportSubscriptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUsageReportSubscriptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes the UserStackAssociation objects. You must specify either or both of the following:
     * + The stack name
     * + The user name (email address of the user associated with the stack) and the authentication type for the user
     */
    override suspend fun describeUserStackAssociations(input: DescribeUserStackAssociationsRequest): DescribeUserStackAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeUserStackAssociationsRequest, DescribeUserStackAssociationsResponse> {
            serializer = DescribeUserStackAssociationsOperationSerializer()
            deserializer = DescribeUserStackAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUserStackAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list that describes one or more specified users in the user pool.
     */
    override suspend fun describeUsers(input: DescribeUsersRequest): DescribeUsersResponse {
        val op = SdkHttpOperation.build<DescribeUsersRequest, DescribeUsersResponse> {
            serializer = DescribeUsersOperationSerializer()
            deserializer = DescribeUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables the specified user in the user pool. Users can't sign in to AppStream 2.0 until they are re-enabled. This action does not delete the user.
     */
    override suspend fun disableUser(input: DisableUserRequest): DisableUserResponse {
        val op = SdkHttpOperation.build<DisableUserRequest, DisableUserResponse> {
            serializer = DisableUserOperationSerializer()
            deserializer = DisableUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified application from the fleet.
     */
    override suspend fun disassociateApplicationFleet(input: DisassociateApplicationFleetRequest): DisassociateApplicationFleetResponse {
        val op = SdkHttpOperation.build<DisassociateApplicationFleetRequest, DisassociateApplicationFleetResponse> {
            serializer = DisassociateApplicationFleetOperationSerializer()
            deserializer = DisassociateApplicationFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateApplicationFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified application from the specified entitlement.
     */
    override suspend fun disassociateApplicationFromEntitlement(input: DisassociateApplicationFromEntitlementRequest): DisassociateApplicationFromEntitlementResponse {
        val op = SdkHttpOperation.build<DisassociateApplicationFromEntitlementRequest, DisassociateApplicationFromEntitlementResponse> {
            serializer = DisassociateApplicationFromEntitlementOperationSerializer()
            deserializer = DisassociateApplicationFromEntitlementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateApplicationFromEntitlement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified fleet from the specified stack.
     */
    override suspend fun disassociateFleet(input: DisassociateFleetRequest): DisassociateFleetResponse {
        val op = SdkHttpOperation.build<DisassociateFleetRequest, DisassociateFleetResponse> {
            serializer = DisassociateFleetOperationSerializer()
            deserializer = DisassociateFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0 and open applications from the stacks to which they are assigned.
     */
    override suspend fun enableUser(input: EnableUserRequest): EnableUserResponse {
        val op = SdkHttpOperation.build<EnableUserRequest, EnableUserResponse> {
            serializer = EnableUserOperationSerializer()
            deserializer = EnableUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Immediately stops the specified streaming session.
     */
    override suspend fun expireSession(input: ExpireSessionRequest): ExpireSessionResponse {
        val op = SdkHttpOperation.build<ExpireSessionRequest, ExpireSessionResponse> {
            serializer = ExpireSessionOperationSerializer()
            deserializer = ExpireSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExpireSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the name of the fleet that is associated with the specified stack.
     */
    override suspend fun listAssociatedFleets(input: ListAssociatedFleetsRequest): ListAssociatedFleetsResponse {
        val op = SdkHttpOperation.build<ListAssociatedFleetsRequest, ListAssociatedFleetsResponse> {
            serializer = ListAssociatedFleetsOperationSerializer()
            deserializer = ListAssociatedFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssociatedFleets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the name of the stack with which the specified fleet is associated.
     */
    override suspend fun listAssociatedStacks(input: ListAssociatedStacksRequest): ListAssociatedStacksResponse {
        val op = SdkHttpOperation.build<ListAssociatedStacksRequest, ListAssociatedStacksResponse> {
            serializer = ListAssociatedStacksOperationSerializer()
            deserializer = ListAssociatedStacksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssociatedStacks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of entitled applications.
     */
    override suspend fun listEntitledApplications(input: ListEntitledApplicationsRequest): ListEntitledApplicationsResponse {
        val op = SdkHttpOperation.build<ListEntitledApplicationsRequest, ListEntitledApplicationsResponse> {
            serializer = ListEntitledApplicationsOperationSerializer()
            deserializer = ListEntitledApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEntitledApplications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of all tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.
     *
     * For more information about tags, see [Tagging Your Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html) in the *Amazon AppStream 2.0 Administration Guide*.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts the specified fleet.
     */
    override suspend fun startFleet(input: StartFleetRequest): StartFleetResponse {
        val op = SdkHttpOperation.build<StartFleetRequest, StartFleetResponse> {
            serializer = StartFleetOperationSerializer()
            deserializer = StartFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts the specified image builder.
     */
    override suspend fun startImageBuilder(input: StartImageBuilderRequest): StartImageBuilderResponse {
        val op = SdkHttpOperation.build<StartImageBuilderRequest, StartImageBuilderResponse> {
            serializer = StartImageBuilderOperationSerializer()
            deserializer = StartImageBuilderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartImageBuilder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops the specified fleet.
     */
    override suspend fun stopFleet(input: StopFleetRequest): StopFleetResponse {
        val op = SdkHttpOperation.build<StopFleetRequest, StopFleetResponse> {
            serializer = StopFleetOperationSerializer()
            deserializer = StopFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops the specified image builder.
     */
    override suspend fun stopImageBuilder(input: StopImageBuilderRequest): StopImageBuilderResponse {
        val op = SdkHttpOperation.build<StopImageBuilderRequest, StopImageBuilderResponse> {
            serializer = StopImageBuilderOperationSerializer()
            deserializer = StopImageBuilderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopImageBuilder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or overwrites one or more tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.
     *
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.
     *
     * To list the current tags for your resources, use ListTagsForResource. To disassociate tags from your resources, use UntagResource.
     *
     * For more information about tags, see [Tagging Your Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html) in the *Amazon AppStream 2.0 Administration Guide*.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates one or more specified tags from the specified AppStream 2.0 resource.
     *
     * To list the current tags for your resources, use ListTagsForResource.
     *
     * For more information about tags, see [Tagging Your Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html) in the *Amazon AppStream 2.0 Administration Guide*.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified application.
     */
    override suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse {
        val op = SdkHttpOperation.build<UpdateApplicationRequest, UpdateApplicationResponse> {
            serializer = UpdateApplicationOperationSerializer()
            deserializer = UpdateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
     */
    override suspend fun updateDirectoryConfig(input: UpdateDirectoryConfigRequest): UpdateDirectoryConfigResponse {
        val op = SdkHttpOperation.build<UpdateDirectoryConfigRequest, UpdateDirectoryConfigResponse> {
            serializer = UpdateDirectoryConfigOperationSerializer()
            deserializer = UpdateDirectoryConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDirectoryConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified entitlement.
     */
    override suspend fun updateEntitlement(input: UpdateEntitlementRequest): UpdateEntitlementResponse {
        val op = SdkHttpOperation.build<UpdateEntitlementRequest, UpdateEntitlementResponse> {
            serializer = UpdateEntitlementOperationSerializer()
            deserializer = UpdateEntitlementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEntitlement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified fleet.
     *
     * If the fleet is in the `STOPPED` state, you can update any attribute except the fleet name.
     *
     * If the fleet is in the `RUNNING` state, you can update the following based on the fleet type:
     * + Always-On and On-Demand fleet typesYou can update the `DisplayName`, `ComputeCapacity`, `ImageARN`, `ImageName`, `IdleDisconnectTimeoutInSeconds`, and `DisconnectTimeoutInSeconds` attributes.
     * + Elastic fleet typeYou can update the `DisplayName`, `IdleDisconnectTimeoutInSeconds`, `DisconnectTimeoutInSeconds`, `MaxConcurrentSessions`, and `UsbDeviceFilterStrings` attributes.
     *
     * If the fleet is in the `STARTING` or `STOPPED` state, you can't update it.
     */
    override suspend fun updateFleet(input: UpdateFleetRequest): UpdateFleetResponse {
        val op = SdkHttpOperation.build<UpdateFleetRequest, UpdateFleetResponse> {
            serializer = UpdateFleetOperationSerializer()
            deserializer = UpdateFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates permissions for the specified private image.
     */
    override suspend fun updateImagePermissions(input: UpdateImagePermissionsRequest): UpdateImagePermissionsResponse {
        val op = SdkHttpOperation.build<UpdateImagePermissionsRequest, UpdateImagePermissionsResponse> {
            serializer = UpdateImagePermissionsOperationSerializer()
            deserializer = UpdateImagePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateImagePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified fields for the specified stack.
     */
    override suspend fun updateStack(input: UpdateStackRequest): UpdateStackResponse {
        val op = SdkHttpOperation.build<UpdateStackRequest, UpdateStackResponse> {
            serializer = UpdateStackOperationSerializer()
            deserializer = UpdateStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PhotonAdminProxyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appstream"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "appstream")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
