// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an app block.
 *
 * App blocks are an Amazon AppStream 2.0 resource that stores the details about the virtual hard disk in an S3 bucket. It also stores the setup script with details about how to mount the virtual hard disk. The virtual hard disk includes the application binaries and other files necessary to launch your applications. Multiple applications can be assigned to a single app block.
 *
 * This is only supported for Elastic fleets.
 */
class AppBlock private constructor(builder: Builder) {
    /**
     * The ARN of the app block.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The created time of the app block.
     */
    val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description of the app block.
     */
    val description: kotlin.String? = builder.description
    /**
     * The display name of the app block.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * The name of the app block.
     */
    val name: kotlin.String? = builder.name
    /**
     * The setup script details of the app block.
     */
    val setupScriptDetails: aws.sdk.kotlin.services.appstream.model.ScriptDetails? = builder.setupScriptDetails
    /**
     * The source S3 location of the app block.
     */
    val sourceS3Location: aws.sdk.kotlin.services.appstream.model.S3Location? = builder.sourceS3Location

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.AppBlock = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppBlock(")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("name=$name,")
        append("setupScriptDetails=$setupScriptDetails,")
        append("sourceS3Location=$sourceS3Location)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (setupScriptDetails?.hashCode() ?: 0)
        result = 31 * result + (sourceS3Location?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppBlock

        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (name != other.name) return false
        if (setupScriptDetails != other.setupScriptDetails) return false
        if (sourceS3Location != other.sourceS3Location) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.AppBlock = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the app block.
         */
        var arn: kotlin.String? = null
        /**
         * The created time of the app block.
         */
        var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the app block.
         */
        var description: kotlin.String? = null
        /**
         * The display name of the app block.
         */
        var displayName: kotlin.String? = null
        /**
         * The name of the app block.
         */
        var name: kotlin.String? = null
        /**
         * The setup script details of the app block.
         */
        var setupScriptDetails: aws.sdk.kotlin.services.appstream.model.ScriptDetails? = null
        /**
         * The source S3 location of the app block.
         */
        var sourceS3Location: aws.sdk.kotlin.services.appstream.model.S3Location? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.AppBlock) : this() {
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.description = x.description
            this.displayName = x.displayName
            this.name = x.name
            this.setupScriptDetails = x.setupScriptDetails
            this.sourceS3Location = x.sourceS3Location
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.AppBlock = AppBlock(this)

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.ScriptDetails] inside the given [block]
         */
        fun setupScriptDetails(block: aws.sdk.kotlin.services.appstream.model.ScriptDetails.Builder.() -> kotlin.Unit) {
            this.setupScriptDetails = aws.sdk.kotlin.services.appstream.model.ScriptDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.S3Location] inside the given [block]
         */
        fun sourceS3Location(block: aws.sdk.kotlin.services.appstream.model.S3Location.Builder.() -> kotlin.Unit) {
            this.sourceS3Location = aws.sdk.kotlin.services.appstream.model.S3Location.invoke(block)
        }
    }
}
