// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model



/**
 * Describes the persistent application settings for users of a stack.
 */
class ApplicationSettingsResponse private constructor(builder: Builder) {
    /**
     * Specifies whether persistent application settings are enabled for users during their streaming sessions.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The bucket is unique to the AWS account and the Region.
     */
    val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * The path prefix for the S3 bucket where users’ persistent application settings are stored.
     */
    val settingsGroup: kotlin.String? = builder.settingsGroup

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationSettingsResponse(")
        append("enabled=$enabled,")
        append("s3BucketName=$s3BucketName,")
        append("settingsGroup=$settingsGroup)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (settingsGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationSettingsResponse

        if (enabled != other.enabled) return false
        if (s3BucketName != other.s3BucketName) return false
        if (settingsGroup != other.settingsGroup) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether persistent application settings are enabled for users during their streaming sessions.
         */
        var enabled: kotlin.Boolean = false
        /**
         * The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The bucket is unique to the AWS account and the Region.
         */
        var s3BucketName: kotlin.String? = null
        /**
         * The path prefix for the S3 bucket where users’ persistent application settings are stored.
         */
        var settingsGroup: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse) : this() {
            this.enabled = x.enabled
            this.s3BucketName = x.s3BucketName
            this.settingsGroup = x.settingsGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse = ApplicationSettingsResponse(this)
    }
}
