// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model



class CreateApplicationRequest private constructor(builder: Builder) {
    /**
     * The app block ARN to which the application should be associated
     */
    val appBlockArn: kotlin.String? = builder.appBlockArn
    /**
     * The description of the application.
     */
    val description: kotlin.String? = builder.description
    /**
     * The display name of the application. This name is visible to users in the application catalog.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * The location in S3 of the application icon.
     */
    val iconS3Location: aws.sdk.kotlin.services.appstream.model.S3Location? = builder.iconS3Location
    /**
     * The instance families the application supports. Valid values are GENERAL_PURPOSE and GRAPHICS_G4.
     */
    val instanceFamilies: List<String>? = builder.instanceFamilies
    /**
     * The launch parameters of the application.
     */
    val launchParameters: kotlin.String? = builder.launchParameters
    /**
     * The launch path of the application.
     */
    val launchPath: kotlin.String? = builder.launchPath
    /**
     * The name of the application. This name is visible to users when display name is not specified.
     */
    val name: kotlin.String? = builder.name
    /**
     * The platforms the application supports. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
     */
    val platforms: List<PlatformType>? = builder.platforms
    /**
     * The tags assigned to the application.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The working directory of the application.
     */
    val workingDirectory: kotlin.String? = builder.workingDirectory

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.CreateApplicationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApplicationRequest(")
        append("appBlockArn=$appBlockArn,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("iconS3Location=$iconS3Location,")
        append("instanceFamilies=$instanceFamilies,")
        append("launchParameters=$launchParameters,")
        append("launchPath=$launchPath,")
        append("name=$name,")
        append("platforms=$platforms,")
        append("tags=$tags,")
        append("workingDirectory=$workingDirectory)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appBlockArn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (iconS3Location?.hashCode() ?: 0)
        result = 31 * result + (instanceFamilies?.hashCode() ?: 0)
        result = 31 * result + (launchParameters?.hashCode() ?: 0)
        result = 31 * result + (launchPath?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platforms?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workingDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApplicationRequest

        if (appBlockArn != other.appBlockArn) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (iconS3Location != other.iconS3Location) return false
        if (instanceFamilies != other.instanceFamilies) return false
        if (launchParameters != other.launchParameters) return false
        if (launchPath != other.launchPath) return false
        if (name != other.name) return false
        if (platforms != other.platforms) return false
        if (tags != other.tags) return false
        if (workingDirectory != other.workingDirectory) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.CreateApplicationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The app block ARN to which the application should be associated
         */
        var appBlockArn: kotlin.String? = null
        /**
         * The description of the application.
         */
        var description: kotlin.String? = null
        /**
         * The display name of the application. This name is visible to users in the application catalog.
         */
        var displayName: kotlin.String? = null
        /**
         * The location in S3 of the application icon.
         */
        var iconS3Location: aws.sdk.kotlin.services.appstream.model.S3Location? = null
        /**
         * The instance families the application supports. Valid values are GENERAL_PURPOSE and GRAPHICS_G4.
         */
        var instanceFamilies: List<String>? = null
        /**
         * The launch parameters of the application.
         */
        var launchParameters: kotlin.String? = null
        /**
         * The launch path of the application.
         */
        var launchPath: kotlin.String? = null
        /**
         * The name of the application. This name is visible to users when display name is not specified.
         */
        var name: kotlin.String? = null
        /**
         * The platforms the application supports. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.
         */
        var platforms: List<PlatformType>? = null
        /**
         * The tags assigned to the application.
         */
        var tags: Map<String, String>? = null
        /**
         * The working directory of the application.
         */
        var workingDirectory: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.CreateApplicationRequest) : this() {
            this.appBlockArn = x.appBlockArn
            this.description = x.description
            this.displayName = x.displayName
            this.iconS3Location = x.iconS3Location
            this.instanceFamilies = x.instanceFamilies
            this.launchParameters = x.launchParameters
            this.launchPath = x.launchPath
            this.name = x.name
            this.platforms = x.platforms
            this.tags = x.tags
            this.workingDirectory = x.workingDirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.CreateApplicationRequest = CreateApplicationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.S3Location] inside the given [block]
         */
        fun iconS3Location(block: aws.sdk.kotlin.services.appstream.model.S3Location.Builder.() -> kotlin.Unit) {
            this.iconS3Location = aws.sdk.kotlin.services.appstream.model.S3Location.invoke(block)
        }
    }
}
