// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model



class CreateImageBuilderRequest private constructor(builder: Builder) {
    /**
     * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.
     */
    val accessEndpoints: List<AccessEndpoint>? = builder.accessEndpoints
    /**
     * The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify &#91;LATEST&#93;.
     */
    val appstreamAgentVersion: kotlin.String? = builder.appstreamAgentVersion
    /**
     * The description to display.
     */
    val description: kotlin.String? = builder.description
    /**
     * The image builder name to display.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain.
     */
    val domainJoinInfo: aws.sdk.kotlin.services.appstream.model.DomainJoinInfo? = builder.domainJoinInfo
    /**
     * Enables or disables default internet access for the image builder.
     */
    val enableDefaultInternetAccess: kotlin.Boolean? = builder.enableDefaultInternetAccess
    /**
     * The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) `AssumeRole` API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the **appstream_machine_role** credential profile on the instance.
     *
     * For more information, see [Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html) in the *Amazon AppStream 2.0 Administration Guide*.
     */
    val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The ARN of the public, private, or shared image to use.
     */
    val imageArn: kotlin.String? = builder.imageArn
    /**
     * The name of the image used to create the image builder.
     */
    val imageName: kotlin.String? = builder.imageName
    /**
     * The instance type to use when launching the image builder. The following instance types are available:
     * + stream.standard.small
     * + stream.standard.medium
     * + stream.standard.large
     * + stream.compute.large
     * + stream.compute.xlarge
     * + stream.compute.2xlarge
     * + stream.compute.4xlarge
     * + stream.compute.8xlarge
     * + stream.memory.large
     * + stream.memory.xlarge
     * + stream.memory.2xlarge
     * + stream.memory.4xlarge
     * + stream.memory.8xlarge
     * + stream.memory.z1d.large
     * + stream.memory.z1d.xlarge
     * + stream.memory.z1d.2xlarge
     * + stream.memory.z1d.3xlarge
     * + stream.memory.z1d.6xlarge
     * + stream.memory.z1d.12xlarge
     * + stream.graphics-design.large
     * + stream.graphics-design.xlarge
     * + stream.graphics-design.2xlarge
     * + stream.graphics-design.4xlarge
     * + stream.graphics-desktop.2xlarge
     * + stream.graphics.g4dn.xlarge
     * + stream.graphics.g4dn.2xlarge
     * + stream.graphics.g4dn.4xlarge
     * + stream.graphics.g4dn.8xlarge
     * + stream.graphics.g4dn.12xlarge
     * + stream.graphics.g4dn.16xlarge
     * + stream.graphics-pro.4xlarge
     * + stream.graphics-pro.8xlarge
     * + stream.graphics-pro.16xlarge
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * A unique name for the image builder.
     */
    val name: kotlin.String? = builder.name
    /**
     * The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=.
     *
     * Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters:
     *
     * _ . : / = + \ - @
     *
     * If you do not specify a value, the value is set to an empty string.
     *
     * For more information about tags, see [Tagging Your Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html) in the *Amazon AppStream 2.0 Administration Guide*.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The VPC configuration for the image builder. You can specify only one subnet.
     */
    val vpcConfig: aws.sdk.kotlin.services.appstream.model.VpcConfig? = builder.vpcConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.CreateImageBuilderRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateImageBuilderRequest(")
        append("accessEndpoints=$accessEndpoints,")
        append("appstreamAgentVersion=$appstreamAgentVersion,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("domainJoinInfo=$domainJoinInfo,")
        append("enableDefaultInternetAccess=$enableDefaultInternetAccess,")
        append("iamRoleArn=$iamRoleArn,")
        append("imageArn=$imageArn,")
        append("imageName=$imageName,")
        append("instanceType=$instanceType,")
        append("name=$name,")
        append("tags=$tags,")
        append("vpcConfig=$vpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessEndpoints?.hashCode() ?: 0
        result = 31 * result + (appstreamAgentVersion?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (domainJoinInfo?.hashCode() ?: 0)
        result = 31 * result + (enableDefaultInternetAccess?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (imageArn?.hashCode() ?: 0)
        result = 31 * result + (imageName?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateImageBuilderRequest

        if (accessEndpoints != other.accessEndpoints) return false
        if (appstreamAgentVersion != other.appstreamAgentVersion) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (domainJoinInfo != other.domainJoinInfo) return false
        if (enableDefaultInternetAccess != other.enableDefaultInternetAccess) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (imageArn != other.imageArn) return false
        if (imageName != other.imageName) return false
        if (instanceType != other.instanceType) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.CreateImageBuilderRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.
         */
        var accessEndpoints: List<AccessEndpoint>? = null
        /**
         * The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify &#91;LATEST&#93;.
         */
        var appstreamAgentVersion: kotlin.String? = null
        /**
         * The description to display.
         */
        var description: kotlin.String? = null
        /**
         * The image builder name to display.
         */
        var displayName: kotlin.String? = null
        /**
         * The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain.
         */
        var domainJoinInfo: aws.sdk.kotlin.services.appstream.model.DomainJoinInfo? = null
        /**
         * Enables or disables default internet access for the image builder.
         */
        var enableDefaultInternetAccess: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) `AssumeRole` API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the **appstream_machine_role** credential profile on the instance.
         *
         * For more information, see [Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html) in the *Amazon AppStream 2.0 Administration Guide*.
         */
        var iamRoleArn: kotlin.String? = null
        /**
         * The ARN of the public, private, or shared image to use.
         */
        var imageArn: kotlin.String? = null
        /**
         * The name of the image used to create the image builder.
         */
        var imageName: kotlin.String? = null
        /**
         * The instance type to use when launching the image builder. The following instance types are available:
         * + stream.standard.small
         * + stream.standard.medium
         * + stream.standard.large
         * + stream.compute.large
         * + stream.compute.xlarge
         * + stream.compute.2xlarge
         * + stream.compute.4xlarge
         * + stream.compute.8xlarge
         * + stream.memory.large
         * + stream.memory.xlarge
         * + stream.memory.2xlarge
         * + stream.memory.4xlarge
         * + stream.memory.8xlarge
         * + stream.memory.z1d.large
         * + stream.memory.z1d.xlarge
         * + stream.memory.z1d.2xlarge
         * + stream.memory.z1d.3xlarge
         * + stream.memory.z1d.6xlarge
         * + stream.memory.z1d.12xlarge
         * + stream.graphics-design.large
         * + stream.graphics-design.xlarge
         * + stream.graphics-design.2xlarge
         * + stream.graphics-design.4xlarge
         * + stream.graphics-desktop.2xlarge
         * + stream.graphics.g4dn.xlarge
         * + stream.graphics.g4dn.2xlarge
         * + stream.graphics.g4dn.4xlarge
         * + stream.graphics.g4dn.8xlarge
         * + stream.graphics.g4dn.12xlarge
         * + stream.graphics.g4dn.16xlarge
         * + stream.graphics-pro.4xlarge
         * + stream.graphics-pro.8xlarge
         * + stream.graphics-pro.16xlarge
         */
        var instanceType: kotlin.String? = null
        /**
         * A unique name for the image builder.
         */
        var name: kotlin.String? = null
        /**
         * The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=.
         *
         * Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters:
         *
         * _ . : / = + \ - @
         *
         * If you do not specify a value, the value is set to an empty string.
         *
         * For more information about tags, see [Tagging Your Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html) in the *Amazon AppStream 2.0 Administration Guide*.
         */
        var tags: Map<String, String>? = null
        /**
         * The VPC configuration for the image builder. You can specify only one subnet.
         */
        var vpcConfig: aws.sdk.kotlin.services.appstream.model.VpcConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.CreateImageBuilderRequest) : this() {
            this.accessEndpoints = x.accessEndpoints
            this.appstreamAgentVersion = x.appstreamAgentVersion
            this.description = x.description
            this.displayName = x.displayName
            this.domainJoinInfo = x.domainJoinInfo
            this.enableDefaultInternetAccess = x.enableDefaultInternetAccess
            this.iamRoleArn = x.iamRoleArn
            this.imageArn = x.imageArn
            this.imageName = x.imageName
            this.instanceType = x.instanceType
            this.name = x.name
            this.tags = x.tags
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.CreateImageBuilderRequest = CreateImageBuilderRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.DomainJoinInfo] inside the given [block]
         */
        fun domainJoinInfo(block: aws.sdk.kotlin.services.appstream.model.DomainJoinInfo.Builder.() -> kotlin.Unit) {
            this.domainJoinInfo = aws.sdk.kotlin.services.appstream.model.DomainJoinInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.VpcConfig] inside the given [block]
         */
        fun vpcConfig(block: aws.sdk.kotlin.services.appstream.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.appstream.model.VpcConfig.invoke(block)
        }
    }
}
