// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model



class CreateStreamingUrlRequest private constructor(builder: Builder) {
    /**
     * The name of the application to launch after the session starts. This is the name that you specified as **Name** in the Image Assistant. If your fleet is enabled for the **Desktop** stream view, you can also choose to launch directly to the operating system desktop. To do so, specify **Desktop**.
     */
    val applicationId: kotlin.String? = builder.applicationId
    /**
     * The name of the fleet.
     */
    val fleetName: kotlin.String? = builder.fleetName
    /**
     * The session context. For more information, see [Session Context](https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters) in the *Amazon AppStream 2.0 Administration Guide*.
     */
    val sessionContext: kotlin.String? = builder.sessionContext
    /**
     * The name of the stack.
     */
    val stackName: kotlin.String? = builder.stackName
    /**
     * The identifier of the user.
     */
    val userId: kotlin.String? = builder.userId
    /**
     * The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 60 seconds.
     */
    val validity: kotlin.Long? = builder.validity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.CreateStreamingUrlRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStreamingUrlRequest(")
        append("applicationId=$applicationId,")
        append("fleetName=$fleetName,")
        append("sessionContext=$sessionContext,")
        append("stackName=$stackName,")
        append("userId=$userId,")
        append("validity=$validity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (fleetName?.hashCode() ?: 0)
        result = 31 * result + (sessionContext?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        result = 31 * result + (validity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStreamingUrlRequest

        if (applicationId != other.applicationId) return false
        if (fleetName != other.fleetName) return false
        if (sessionContext != other.sessionContext) return false
        if (stackName != other.stackName) return false
        if (userId != other.userId) return false
        if (validity != other.validity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.CreateStreamingUrlRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the application to launch after the session starts. This is the name that you specified as **Name** in the Image Assistant. If your fleet is enabled for the **Desktop** stream view, you can also choose to launch directly to the operating system desktop. To do so, specify **Desktop**.
         */
        var applicationId: kotlin.String? = null
        /**
         * The name of the fleet.
         */
        var fleetName: kotlin.String? = null
        /**
         * The session context. For more information, see [Session Context](https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters) in the *Amazon AppStream 2.0 Administration Guide*.
         */
        var sessionContext: kotlin.String? = null
        /**
         * The name of the stack.
         */
        var stackName: kotlin.String? = null
        /**
         * The identifier of the user.
         */
        var userId: kotlin.String? = null
        /**
         * The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 60 seconds.
         */
        var validity: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.CreateStreamingUrlRequest) : this() {
            this.applicationId = x.applicationId
            this.fleetName = x.fleetName
            this.sessionContext = x.sessionContext
            this.stackName = x.stackName
            this.userId = x.userId
            this.validity = x.validity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.CreateStreamingUrlRequest = CreateStreamingUrlRequest(this)
    }
}
