// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies an entitlement. Entitlements control access to specific applications within a stack, based on user attributes. Entitlements apply to SAML 2.0 federated user identities. Amazon AppStream 2.0 user pool and streaming URL users are entitled to all applications in a stack. Entitlements don't apply to the desktop stream view application, or to applications managed by a dynamic app provider using the Dynamic Application Framework.
 */
class Entitlement private constructor(builder: Builder) {
    /**
     * Specifies whether all or selected apps are entitled.
     */
    val appVisibility: aws.sdk.kotlin.services.appstream.model.AppVisibility? = builder.appVisibility
    /**
     * The attributes of the entitlement.
     */
    val attributes: List<EntitlementAttribute>? = builder.attributes
    /**
     * The time when the entitlement was created.
     */
    val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description of the entitlement.
     */
    val description: kotlin.String? = builder.description
    /**
     * The time when the entitlement was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the entitlement.
     */
    val name: kotlin.String? = builder.name
    /**
     * The name of the stack with which the entitlement is associated.
     */
    val stackName: kotlin.String? = builder.stackName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.Entitlement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Entitlement(")
        append("appVisibility=$appVisibility,")
        append("attributes=$attributes,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("stackName=$stackName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appVisibility?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Entitlement

        if (appVisibility != other.appVisibility) return false
        if (attributes != other.attributes) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (stackName != other.stackName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.Entitlement = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether all or selected apps are entitled.
         */
        var appVisibility: aws.sdk.kotlin.services.appstream.model.AppVisibility? = null
        /**
         * The attributes of the entitlement.
         */
        var attributes: List<EntitlementAttribute>? = null
        /**
         * The time when the entitlement was created.
         */
        var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the entitlement.
         */
        var description: kotlin.String? = null
        /**
         * The time when the entitlement was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the entitlement.
         */
        var name: kotlin.String? = null
        /**
         * The name of the stack with which the entitlement is associated.
         */
        var stackName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.Entitlement) : this() {
            this.appVisibility = x.appVisibility
            this.attributes = x.attributes
            this.createdTime = x.createdTime
            this.description = x.description
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.stackName = x.stackName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.Entitlement = Entitlement(this)
    }
}
