// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a virtual machine that is used to create an image.
 */
class ImageBuilder private constructor(builder: Builder) {
    /**
     * The list of virtual private cloud (VPC) interface endpoint objects. Administrators can connect to the image builder only through the specified endpoints.
     */
    val accessEndpoints: List<AccessEndpoint>? = builder.accessEndpoints
    /**
     * The version of the AppStream 2.0 agent that is currently being used by the image builder.
     */
    val appstreamAgentVersion: kotlin.String? = builder.appstreamAgentVersion
    /**
     * The ARN for the image builder.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The time stamp when the image builder was created.
     */
    val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description to display.
     */
    val description: kotlin.String? = builder.description
    /**
     * The image builder name to display.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain.
     */
    val domainJoinInfo: aws.sdk.kotlin.services.appstream.model.DomainJoinInfo? = builder.domainJoinInfo
    /**
     * Enables or disables default internet access for the image builder.
     */
    val enableDefaultInternetAccess: kotlin.Boolean? = builder.enableDefaultInternetAccess
    /**
     * The ARN of the IAM role that is applied to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) `AssumeRole` API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the **appstream_machine_role** credential profile on the instance.
     *
     * For more information, see [Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html) in the *Amazon AppStream 2.0 Administration Guide*.
     */
    val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The ARN of the image from which this builder was created.
     */
    val imageArn: kotlin.String? = builder.imageArn
    /**
     * The image builder errors.
     */
    val imageBuilderErrors: List<ResourceError>? = builder.imageBuilderErrors
    /**
     * The instance type for the image builder. The following instance types are available:
     * + stream.standard.small
     * + stream.standard.medium
     * + stream.standard.large
     * + stream.compute.large
     * + stream.compute.xlarge
     * + stream.compute.2xlarge
     * + stream.compute.4xlarge
     * + stream.compute.8xlarge
     * + stream.memory.large
     * + stream.memory.xlarge
     * + stream.memory.2xlarge
     * + stream.memory.4xlarge
     * + stream.memory.8xlarge
     * + stream.memory.z1d.large
     * + stream.memory.z1d.xlarge
     * + stream.memory.z1d.2xlarge
     * + stream.memory.z1d.3xlarge
     * + stream.memory.z1d.6xlarge
     * + stream.memory.z1d.12xlarge
     * + stream.graphics-design.large
     * + stream.graphics-design.xlarge
     * + stream.graphics-design.2xlarge
     * + stream.graphics-design.4xlarge
     * + stream.graphics-desktop.2xlarge
     * + stream.graphics.g4dn.xlarge
     * + stream.graphics.g4dn.2xlarge
     * + stream.graphics.g4dn.4xlarge
     * + stream.graphics.g4dn.8xlarge
     * + stream.graphics.g4dn.12xlarge
     * + stream.graphics.g4dn.16xlarge
     * + stream.graphics-pro.4xlarge
     * + stream.graphics-pro.8xlarge
     * + stream.graphics-pro.16xlarge
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The name of the image builder.
     */
    val name: kotlin.String? = builder.name
    /**
     * Describes the network details of the fleet or image builder instance.
     */
    val networkAccessConfiguration: aws.sdk.kotlin.services.appstream.model.NetworkAccessConfiguration? = builder.networkAccessConfiguration
    /**
     * The operating system platform of the image builder.
     */
    val platform: aws.sdk.kotlin.services.appstream.model.PlatformType? = builder.platform
    /**
     * The state of the image builder.
     */
    val state: aws.sdk.kotlin.services.appstream.model.ImageBuilderState? = builder.state
    /**
     * The reason why the last state change occurred.
     */
    val stateChangeReason: aws.sdk.kotlin.services.appstream.model.ImageBuilderStateChangeReason? = builder.stateChangeReason
    /**
     * The VPC configuration of the image builder.
     */
    val vpcConfig: aws.sdk.kotlin.services.appstream.model.VpcConfig? = builder.vpcConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.ImageBuilder = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageBuilder(")
        append("accessEndpoints=$accessEndpoints,")
        append("appstreamAgentVersion=$appstreamAgentVersion,")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("domainJoinInfo=$domainJoinInfo,")
        append("enableDefaultInternetAccess=$enableDefaultInternetAccess,")
        append("iamRoleArn=$iamRoleArn,")
        append("imageArn=$imageArn,")
        append("imageBuilderErrors=$imageBuilderErrors,")
        append("instanceType=$instanceType,")
        append("name=$name,")
        append("networkAccessConfiguration=$networkAccessConfiguration,")
        append("platform=$platform,")
        append("state=$state,")
        append("stateChangeReason=$stateChangeReason,")
        append("vpcConfig=$vpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessEndpoints?.hashCode() ?: 0
        result = 31 * result + (appstreamAgentVersion?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (domainJoinInfo?.hashCode() ?: 0)
        result = 31 * result + (enableDefaultInternetAccess?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (imageArn?.hashCode() ?: 0)
        result = 31 * result + (imageBuilderErrors?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkAccessConfiguration?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateChangeReason?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageBuilder

        if (accessEndpoints != other.accessEndpoints) return false
        if (appstreamAgentVersion != other.appstreamAgentVersion) return false
        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (domainJoinInfo != other.domainJoinInfo) return false
        if (enableDefaultInternetAccess != other.enableDefaultInternetAccess) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (imageArn != other.imageArn) return false
        if (imageBuilderErrors != other.imageBuilderErrors) return false
        if (instanceType != other.instanceType) return false
        if (name != other.name) return false
        if (networkAccessConfiguration != other.networkAccessConfiguration) return false
        if (platform != other.platform) return false
        if (state != other.state) return false
        if (stateChangeReason != other.stateChangeReason) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.ImageBuilder = Builder(this).apply(block).build()

    class Builder {
        /**
         * The list of virtual private cloud (VPC) interface endpoint objects. Administrators can connect to the image builder only through the specified endpoints.
         */
        var accessEndpoints: List<AccessEndpoint>? = null
        /**
         * The version of the AppStream 2.0 agent that is currently being used by the image builder.
         */
        var appstreamAgentVersion: kotlin.String? = null
        /**
         * The ARN for the image builder.
         */
        var arn: kotlin.String? = null
        /**
         * The time stamp when the image builder was created.
         */
        var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description to display.
         */
        var description: kotlin.String? = null
        /**
         * The image builder name to display.
         */
        var displayName: kotlin.String? = null
        /**
         * The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain.
         */
        var domainJoinInfo: aws.sdk.kotlin.services.appstream.model.DomainJoinInfo? = null
        /**
         * Enables or disables default internet access for the image builder.
         */
        var enableDefaultInternetAccess: kotlin.Boolean? = null
        /**
         * The ARN of the IAM role that is applied to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) `AssumeRole` API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the **appstream_machine_role** credential profile on the instance.
         *
         * For more information, see [Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html) in the *Amazon AppStream 2.0 Administration Guide*.
         */
        var iamRoleArn: kotlin.String? = null
        /**
         * The ARN of the image from which this builder was created.
         */
        var imageArn: kotlin.String? = null
        /**
         * The image builder errors.
         */
        var imageBuilderErrors: List<ResourceError>? = null
        /**
         * The instance type for the image builder. The following instance types are available:
         * + stream.standard.small
         * + stream.standard.medium
         * + stream.standard.large
         * + stream.compute.large
         * + stream.compute.xlarge
         * + stream.compute.2xlarge
         * + stream.compute.4xlarge
         * + stream.compute.8xlarge
         * + stream.memory.large
         * + stream.memory.xlarge
         * + stream.memory.2xlarge
         * + stream.memory.4xlarge
         * + stream.memory.8xlarge
         * + stream.memory.z1d.large
         * + stream.memory.z1d.xlarge
         * + stream.memory.z1d.2xlarge
         * + stream.memory.z1d.3xlarge
         * + stream.memory.z1d.6xlarge
         * + stream.memory.z1d.12xlarge
         * + stream.graphics-design.large
         * + stream.graphics-design.xlarge
         * + stream.graphics-design.2xlarge
         * + stream.graphics-design.4xlarge
         * + stream.graphics-desktop.2xlarge
         * + stream.graphics.g4dn.xlarge
         * + stream.graphics.g4dn.2xlarge
         * + stream.graphics.g4dn.4xlarge
         * + stream.graphics.g4dn.8xlarge
         * + stream.graphics.g4dn.12xlarge
         * + stream.graphics.g4dn.16xlarge
         * + stream.graphics-pro.4xlarge
         * + stream.graphics-pro.8xlarge
         * + stream.graphics-pro.16xlarge
         */
        var instanceType: kotlin.String? = null
        /**
         * The name of the image builder.
         */
        var name: kotlin.String? = null
        /**
         * Describes the network details of the fleet or image builder instance.
         */
        var networkAccessConfiguration: aws.sdk.kotlin.services.appstream.model.NetworkAccessConfiguration? = null
        /**
         * The operating system platform of the image builder.
         */
        var platform: aws.sdk.kotlin.services.appstream.model.PlatformType? = null
        /**
         * The state of the image builder.
         */
        var state: aws.sdk.kotlin.services.appstream.model.ImageBuilderState? = null
        /**
         * The reason why the last state change occurred.
         */
        var stateChangeReason: aws.sdk.kotlin.services.appstream.model.ImageBuilderStateChangeReason? = null
        /**
         * The VPC configuration of the image builder.
         */
        var vpcConfig: aws.sdk.kotlin.services.appstream.model.VpcConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.ImageBuilder) : this() {
            this.accessEndpoints = x.accessEndpoints
            this.appstreamAgentVersion = x.appstreamAgentVersion
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.description = x.description
            this.displayName = x.displayName
            this.domainJoinInfo = x.domainJoinInfo
            this.enableDefaultInternetAccess = x.enableDefaultInternetAccess
            this.iamRoleArn = x.iamRoleArn
            this.imageArn = x.imageArn
            this.imageBuilderErrors = x.imageBuilderErrors
            this.instanceType = x.instanceType
            this.name = x.name
            this.networkAccessConfiguration = x.networkAccessConfiguration
            this.platform = x.platform
            this.state = x.state
            this.stateChangeReason = x.stateChangeReason
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.ImageBuilder = ImageBuilder(this)

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.DomainJoinInfo] inside the given [block]
         */
        fun domainJoinInfo(block: aws.sdk.kotlin.services.appstream.model.DomainJoinInfo.Builder.() -> kotlin.Unit) {
            this.domainJoinInfo = aws.sdk.kotlin.services.appstream.model.DomainJoinInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.NetworkAccessConfiguration] inside the given [block]
         */
        fun networkAccessConfiguration(block: aws.sdk.kotlin.services.appstream.model.NetworkAccessConfiguration.Builder.() -> kotlin.Unit) {
            this.networkAccessConfiguration = aws.sdk.kotlin.services.appstream.model.NetworkAccessConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.ImageBuilderStateChangeReason] inside the given [block]
         */
        fun stateChangeReason(block: aws.sdk.kotlin.services.appstream.model.ImageBuilderStateChangeReason.Builder.() -> kotlin.Unit) {
            this.stateChangeReason = aws.sdk.kotlin.services.appstream.model.ImageBuilderStateChangeReason.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.VpcConfig] inside the given [block]
         */
        fun vpcConfig(block: aws.sdk.kotlin.services.appstream.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.appstream.model.VpcConfig.invoke(block)
        }
    }
}
